<div class="card mb-4">
    <div class="card-header">
        <h6 class="mb-0"><?php echo app('translator')->get('widgets.admin.trafficGraph'); ?></h6>
    </div>
    <div class="card-body card-height">
        <div class="c-chart-wrapper" style="height:300px;margin-top:40px;">
            <canvas class="chart" id="main-chart" height="300"></canvas>
        </div>
    </div>
</div>
<script>
    var ctx = document.getElementById("main-chart").getContext('2d');
    var myChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: <?php echo json_encode($graphData['labels'], 15, 512) ?>,
            datasets: [{
                    label: '<?php echo e(__('admin.views')); ?>',
                    data: <?php echo json_encode($graphData['tools'], 15, 512) ?>,
                    fill: false,
                    borderColor: '#FA8617',
                    backgroundColor: '#FA8617',
                    borderWidth: 2,
                    borderDashOffset: 1
                },
                {
                    label: '<?php echo e(__('admin.usage')); ?>',
                    data: <?php echo json_encode($graphData['visits'], 15, 512) ?>,
                    fill: false,
                    borderColor: '#39f',
                    backgroundColor: '#39f',
                    borderWidth: 2,
                    borderDashOffset: 1
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            bezierCurve: false,
            plugins: {
                legend: {
                    display: false
                }
            },
            elements: {
                point: {
                    radius: 0
                },
                line: {
                    tension: .4
                }
            }
        },
    });
</script>
<?php /**PATH /home/newuserdapi/toolsfi.co/resources/themes/admin/widgets/admin/graphs.blade.php ENDPATH**/ ?>