<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'accept' => '.pdf',
    'maxSize' => null,
    'maxFiles' => 1,
    'fileTitle' => __('tools.dropPDFHereTitle'),
    'fileLabel' => __('admin.selectFileOrDrag'),
    'buttonLabel' => __('admin.selectAFile'),
    'id' => 'file-uploader',
    'dropOnBody' => true,
    'inputName' => 'files',
    'onSelectFile' => null,
    'pages' => 'false',
    'preview' => 'true',
    'rotate' => 'true',
    'sortable' => 'false',
    'callbacks' => '{}',
    'equalHeight' => false,
    'allowProtectedFiles' => 'true',
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'accept' => '.pdf',
    'maxSize' => null,
    'maxFiles' => 1,
    'fileTitle' => __('tools.dropPDFHereTitle'),
    'fileLabel' => __('admin.selectFileOrDrag'),
    'buttonLabel' => __('admin.selectAFile'),
    'id' => 'file-uploader',
    'dropOnBody' => true,
    'inputName' => 'files',
    'onSelectFile' => null,
    'pages' => 'false',
    'preview' => 'true',
    'rotate' => 'true',
    'sortable' => 'false',
    'callbacks' => '{}',
    'equalHeight' => false,
    'allowProtectedFiles' => 'true',
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>
<div class="artisan-uploader bg-light rounded uploader-<?php echo e($id); ?><?php echo e(!$equalHeight ? '' : ' h-100'); ?>">
    <input id="<?php echo e($id); ?>" type="file" name="<?php echo e($inputName); ?>"
        accept="<?php echo e($accept); ?>"<?php echo e($maxFiles > 1 ? ' multiple' : ''); ?> />
    <input type="hidden" class="pdf_file__data" name="fileData">
    <div class="bg-priamary p-2 add-more d-none">
        <div class="d-flex justify-content-between align-items-center">
            <label class="btn btn-primary btn-pill" for="<?php echo e($id); ?>">+</label>
            <div class="ml-auto pdf___more-actions">

            </div>
        </div>
    </div>
    <label for="<?php echo e($id); ?>" class="position-relative file-drag<?php echo e($slot->isEmpty() ? '' : ' pb-1'); ?>">
        <div class="file-loader">
            <div class="spinner-grow" role="status">
                <span class="sr-only"><?php echo app('translator')->get('common.loading'); ?></span>
            </div>
        </div>
        <div class="uploader-wrapper">
            <?php if(!empty($svg)): ?>
                <?php echo e($svg); ?>

            <?php else: ?>
                <i class="an an-overview"></i>
            <?php endif; ?>
            <?php if($fileTitle): ?>
                <h3><?php echo e($fileTitle); ?></h3>
            <?php endif; ?>
            <?php if(!empty($accept)): ?>
                <div class="uploader-extensions mb-3">
                    <?php $__currentLoopData = explode(',', $accept); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ext): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span class="badge text-uppercase"><?php echo e($ext); ?></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php endif; ?>
            <p><?php echo e($fileLabel); ?></p>
            <span class="btn btn-dark file-upload-btn"><?php echo e($buttonLabel); ?></span>
        </div>
        <div class="files-grid"></div>
    </label>
    <?php if(!$slot->isEmpty()): ?>
        <div class="uploader-after p-3">
            <?php echo e($slot); ?>

        </div>
    <?php endif; ?>
</div>
<?php $__env->startPush('page_scripts'); ?>
    <script>
        document.addEventListener("DOMContentLoaded", function(event) {
            PDFApp.initPDFUpload(document.querySelector('.uploader-<?php echo e($id); ?>'), {
                    dropOnBody: <?php echo e($dropOnBody ? 'true' : 'false'); ?>,
                    maxFiles: <?php echo e($maxFiles); ?>,
                    previewPages: <?php echo e($pages); ?>,
                    allowPreview: <?php echo e($preview); ?>,
                    allowRotate: <?php echo e($rotate); ?>,
                    isSortable: <?php echo e($sortable); ?>,
                    allowProtectedFiles: <?php echo e($allowProtectedFiles); ?>,
                    fileExtensions: "<?php echo e(Str::replace(',', '|', $accept)); ?>",
                    <?php if(!empty($maxSize)): ?>
                        maxSize: <?php echo e($maxSize); ?>,
                    <?php endif; ?>
                }, {
                    extensionsError: "<?php echo e(__('admin.fileTypeNotSupported')); ?>",
                    sizeError: "<?php echo e(__('admin.maxFileSizeError', ['size' => $maxSize])); ?>",
                    filesError: "<?php echo e(__('admin.maxFileLimitError')); ?>",
                    tooManyInvalidAttempts: "<?php echo e(__('tools.tooManyInvalidAttempts')); ?>",
                    fileNotSupported: "<?php echo e(__('tools.fileNotSupported')); ?>",
                },
                <?php if($callbacks): ?>
                    <?php echo e($callbacks); ?>

                <?php endif; ?>
            );
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/newuserdapi/toolsfi.co/resources/themes/canvas/components/pdf-upload-wrapper.blade.php ENDPATH**/ ?>