<?php if(!isset($innerLoop)): ?>
    <ul class="artisan-nav nav nav-menu ms-auto">
    <?php else: ?>
        <ul class="dropdown-menu" aria-labelledby="navbarDropdown">
<?php endif; ?>

<?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $originalItem = $item;

        $listItemClass = null;
        $linkAttributes = null;
        $styles = null;
        $icon = null;

        // Background Color or Color
        if (isset($options->color) && $options->color == true) {
            $styles = 'color:' . $item->color;
        }
        if (isset($options->background) && $options->background == true) {
            $styles = 'background-color:' . $item->color;
        }

        // With child Attributes
        if (isset($originalItem->child) && !$originalItem->child->isEmpty()) {
            if ($item->active) {
                $linkAttributes = 'class="nav-link dropdown-toggle active" data-bs-toggle="dropdown"';
            } else {
                $linkAttributes = 'class="nav-link dropdown-toggle" data-bs-toggle="dropdown"';
            }
            $listItemClass = 'nav-item dropdown';
        } else {
            $listItemClass = 'nav-item';

            if ($item->active) {
                $linkAttributes = 'class="nav-link active"';
            } else {
                $linkAttributes = 'class="nav-link"';
            }

            if (isset($innerLoop)) {
                $listItemClass = '';
                if ($item->active) {
                    $linkAttributes = 'class="dropdown-item active"';
                } else {
                    $linkAttributes = 'class="dropdown-item"';
                }
            }
        }

        // Set Icon
        if (isset($options->icon) && $options->icon == true && !empty($item->icon_class)) {
            if (Str::contains($item->icon_class, '<svg')) {
                $icon = "{$item->icon_class}";
            } else {
                $icon = '<i class="' . $item->icon_class . '"></i>';
            }
        }
    ?>
    <li class="<?php echo e($listItemClass); ?>">
        <a href="<?php echo e($item->href); ?>" target="<?php echo e($item->target); ?>" style="<?php echo e($styles); ?>" <?php echo $linkAttributes ?? ''; ?>>
            <?php echo $icon; ?>

            <?php echo e($item->label); ?>

        </a>
        <?php if(isset($originalItem->child) && !$originalItem->child->isEmpty()): ?>
            <?php echo $__env->make('menu.bootstrap', [
                'items' => $originalItem->child,
                'options' => $options,
                'innerLoop' => true,
            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
    </li>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php if(auth()->guard()->guest()): ?>
    <?php if(Route::has('login') && !isset($innerLoop) && setting('disable_auth', 0) == 0): ?>
        <li class="nav-item nav-btn">
            <a href="<?php echo e(route('login')); ?>" class="login-modal btn btn-primary rounded-pill"><?php echo app('translator')->get('auth.login'); ?></a>
        </li>
        <?php if(Route::has('register')): ?>
            <li class="nav-item nav-btn">
                <a href="<?php echo e(route('register')); ?>" class="btn btn-outline-primary rounded-pill"><?php echo app('translator')->get('auth.register'); ?></a>
            </li>
        <?php endif; ?>
    <?php endif; ?>
<?php endif; ?>
<?php if(auth()->guard()->check()): ?>
    <?php if(!isset($innerLoop)): ?>
        <?php if(setting('disable_auth', 0) == 0): ?>
            <li class="nav-item dropdown">
                <a href="#" class="nav-link dropdown-toggle" data-bs-toggle="dropdown"><?php echo e(auth()->user()->name); ?></a>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li class="nav-item"><a class="nav-link" role="button"
                            href="<?php echo e(route('user.profile')); ?>"><?php echo e(__('profile.profile')); ?></a></li>
                    <li class="nav-item"><a class="nav-link" role="button"
                            href="<?php echo e(route('user.password')); ?>"><?php echo e(__('common.changePassword')); ?></a></li>
                    <li class="nav-item"><a class="nav-link signoutBtn" role="button"><?php echo e(__('auth.signout')); ?></a></li>
                </ul>
            </li>
        <?php endif; ?>
        <?php if(setting('disable_favorite_tools', '1') == 1): ?>
            <?php if (isset($component)) { $__componentOriginal56aed0fc83a09349fa8051bf69e8173f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal56aed0fc83a09349fa8051bf69e8173f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.favorite-navbar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('favorite-navbar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal56aed0fc83a09349fa8051bf69e8173f)): ?>
<?php $attributes = $__attributesOriginal56aed0fc83a09349fa8051bf69e8173f; ?>
<?php unset($__attributesOriginal56aed0fc83a09349fa8051bf69e8173f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal56aed0fc83a09349fa8051bf69e8173f)): ?>
<?php $component = $__componentOriginal56aed0fc83a09349fa8051bf69e8173f; ?>
<?php unset($__componentOriginal56aed0fc83a09349fa8051bf69e8173f); ?>
<?php endif; ?>
        <?php endif; ?>
    <?php endif; ?>
<?php endif; ?>
</ul>
<?php /**PATH /home/newuserdapi/toolsfi.co/resources/themes/canvas/menu/bootstrap.blade.php ENDPATH**/ ?>