<?php if(!empty($advertisement) && ((Auth::check() && Auth::user()->isAdsAllowed) || !Auth::check())): ?>
    <div
        class="ad-card <?php echo e($advertisement->type == 1 && !empty($advertisement->options['image']) ? ' text-ad' : ' block'); ?>">
        <div class="ad-card-outer">
            <div class="ad-card-wrap bg-info-light">
                <?php if(($advertisement->type == 2 || $advertisement->type == 1) && !empty($advertisement->options['image'])): ?>
                    <a class="ad-card-img" href="<?php echo e($advertisement->options['target_url']); ?>">
                        <div>
                            <img class="img-fluid" src="<?php echo e($advertisement->options['image']); ?>"
                                alt="<?php echo $advertisement->title; ?>" />
                        </div>
                    </a>
                <?php endif; ?>
                <?php if($advertisement->type == 1): ?>
                    <a href="<?php echo e($advertisement->options['target_url']); ?>" target="_blank"
                        rel="nofollow noopener noreferrer">
                        <div class="ad-card-content">
                            <div class="ad-card-title"><?php echo $advertisement->title; ?></div>
                            <div class="ad-card-link"><?php echo e(extractHostname($advertisement->options['target_url'])); ?></div>
                            <?php if(!empty($advertisement->options['description'])): ?>
                                <div class="ad-card-text"><?php echo $advertisement->options['description']; ?></div>
                            <?php endif; ?>
                        </div>
                    </a>
                <?php endif; ?>
                <a href="<?php echo e(route('ads.remove')); ?>" class="ad-remove-button bg-info-light" tabindex="-1" target="_blank"><?php echo app('translator')->get('common.removeAds'); ?></a>
            </div>
            <?php if($advertisement->type == 3 && !empty($advertisement->options['code'])): ?>
                <?php echo $advertisement->options['code']; ?>

            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/newuserdapi/toolsfi.co/resources/themes/canvas/widgets/advertisement.blade.php ENDPATH**/ ?>