<div class="card mb-4">
    <div class="card-header">
        <h6 class="mb-0"><?php echo app('translator')->get('widgets.admin.newUsers'); ?></h6>
    </div>
    <div class="card-body card-height">
        <table class="table table-hover mb-0">
            <thead>
                <tr>
                    <th scope="col">#</th>
                    <th scope="col"><?php echo app('translator')->get('admin.name'); ?></th>
                    <th scope="col"><?php echo app('translator')->get('admin.email'); ?></th>
                    <th scope="col"><?php echo app('translator')->get('admin.status'); ?></th>
                    <th scope="col"></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <th scope="row"><?php echo e($loop->iteration); ?></th>
                        <td><?php echo e($user->name); ?></td>
                        <td><?php echo e($user->email); ?></td>
                        <td>
                            <?php if($user->status == 1): ?>
                                <span class="badge me-1 bg-success"><?php echo app('translator')->get('common.active'); ?></span>
                            <?php else: ?>
                                <span class="badge me-1 bg-danger"><?php echo app('translator')->get('common.inactive'); ?></span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php echo e($user->created_at->diffForHumans()); ?>

                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php /**PATH /home/newuserdapi/toolsfi.co/resources/themes/admin/widgets/admin/userLists.blade.php ENDPATH**/ ?>