<?php

namespace App\Components\Gateways;

use Exception;
use Carbon\Carbon;
use App\Models\Plan;
use Razorpay\Api\Api;
use Illuminate\Http\Request;
use App\Contracts\GatewayInterface;
use Shakurov\Coinbase\Facades\Coinbase as CoinbasePay;

class BankTransfer implements GatewayInterface
{
    protected $request;
    // protected $config;

    public function __construct(Request $request, array $config)
    {
        $this->request = $request;
        // $this->config = $config;
    }

    public function isActive(): bool
    {
        return (bool) setting('bank_transfer_allow', 0);
    }

    public function isConfigured(): bool
    {
        return 1;
    }

    public function getName(): string
    {
        return "BankTransfer";
    }

    public function getIcon(): string
    {
        return '<svg width="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 578 512">
<path d="M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z M343.3,220.5
	c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6
	C308.9,212.8,307,211.3,303.5,211.3z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7C310,230,307.8,228.2,304.2,228.2z
	 M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z M304.2,228.2h-7.8v9.6h7.8
	c3.5,0,5.6-1.6,5.6-4.7C310,230,307.8,228.2,304.2,228.2z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6
	C308.9,212.8,307,211.3,303.5,211.3z M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z
	 M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6C308.9,212.8,307,211.3,303.5,211.3z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7
	C310,230,307.8,228.2,304.2,228.2z M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z
	 M365.9,295.6c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6C373.5,298.8,369.9,295.6,365.9,295.6z M365.9,295.6
	c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6C373.5,298.8,369.9,295.6,365.9,295.6z M304.2,228.2h-7.8v9.6h7.8
	c3.5,0,5.6-1.6,5.6-4.7C310,230,307.8,228.2,304.2,228.2z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6
	C308.9,212.8,307,211.3,303.5,211.3z M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z
	 M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6C308.9,212.8,307,211.3,303.5,211.3z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7
	C310,230,307.8,228.2,304.2,228.2z M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z
	 M365.9,295.6c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6C373.5,298.8,369.9,295.6,365.9,295.6z M365.9,295.6
	c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6C373.5,298.8,369.9,295.6,365.9,295.6z M304.2,228.2h-7.8v9.6h7.8
	c3.5,0,5.6-1.6,5.6-4.7C310,230,307.8,228.2,304.2,228.2z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6
	C308.9,212.8,307,211.3,303.5,211.3z M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z
	 M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6C308.9,212.8,307,211.3,303.5,211.3z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7
	C310,230,307.8,228.2,304.2,228.2z M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z
	 M365.9,295.6c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6C373.5,298.8,369.9,295.6,365.9,295.6z M507,294.8
	c-3.6,0-6.3,2.1-6.9,6h13.4C513.5,297,510.5,294.8,507,294.8z M507,294.8c-3.6,0-6.3,2.1-6.9,6h13.4
	C513.5,297,510.5,294.8,507,294.8z M365.9,295.6c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6
	C373.5,298.8,369.9,295.6,365.9,295.6z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7C310,230,307.8,228.2,304.2,228.2z
	 M308.9,216c0-3.1-2-4.7-5.5-4.7h-7v9.2h7C307,220.5,308.9,219,308.9,216z M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7
	s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z M557,32H21.1C9.5,32,0,41.5,0,53.1v405.7C0,470.5,9.5,480,21.1,480h535.8
	c11.6,0,21.1-9.5,21.1-21V53.1C578,41.5,568.5,32,557,32z M411.5,200.3h10.8v25.5l10.5-14.2H446l-14.5,17.5l14.6,17.3h-13.3
	l-10.7-14.6v14.6h-10.7V200.3z M340.2,211.1c5.2,0,8.9,2.3,10.8,5.5v-5h10.7v34.9H351v-5c-2,3.1-5.6,5.5-10.8,5.5
	c-8.5,0-15.4-7-15.4-18C324.8,218,331.6,211.1,340.2,211.1z M265.5,363.3H31.2v-11.7h234.3V363.3z M206.6,209.2v-5.8h29.6v5.8H206.6
	z M232.9,211.1v105.4h-22.9V211.1H232.9z M209.9,318.8h22.9l7,9.3h-36.9L209.9,318.8z M42,196.4v-12h212.6v12H42z M157.8,209.2v-5.8
	h29.6v5.8H157.8z M184.1,211.1v105.4h-22.9V211.1H184.1z M161.1,318.8h22.9l7,9.3h-36.9L161.1,318.8z M108.3,209.2v-5.8h29.6v5.8
	H108.3z M134.5,211.1v105.4h-22.9V211.1H134.5z M111.6,318.8h22.9l7,9.3h-36.9L111.6,318.8z M61.3,209.2v-5.8h29.6v5.8H61.3z
	 M87.4,211.1v105.4h-23V211.1H87.4z M64.5,318.8h23l7,9.3H57.5L64.5,318.8z M254.6,334.3V346H42v-11.7H254.6z M261.7,181.2H34.8
	c-4.8,0-6.5-6.3-2.4-8.7l104.1-61.3c7.2-4.3,16.2-4.3,23.4,0L264,172.5C268.2,174.9,266.5,181.2,261.7,181.2z M317.4,286.3h-11.6
	v35.3h-10.7v-35.3h-11.6v-8.6h33.9V286.3z M306.2,246.6h-20.5v-43.9h19.8c9,0,14.2,4.4,14.2,11.3c0,5.3-3.1,8.7-7.4,10
	c5.1,1,8.5,5.6,8.5,10.6C320.8,241.9,315.4,246.6,306.2,246.6z M344.4,297.7h-3c-5.1,0-8,1.7-8,7.8v16.2h-10.7v-34.9h10.7v5.9
	c2.5-3.7,6.2-6.2,10.9-6.2V297.7z M384.2,321.6h-10.7v-5c-2,3.1-5.6,5.5-10.8,5.5c-8.5,0-15.4-7-15.4-18c0-11.1,6.8-18,15.4-18
	c5.2,0,8.9,2.3,10.8,5.5v-4.9h10.7V321.6z M386.8,220.1c-4,0-6.7,2.6-6.7,7.4v18.9h-10.7v-34.8h10.7v4.7c2.1-3,5.9-4.9,10.6-4.9
	c8.1,0,13.4,5.5,13.4,14.8v20.3h-10.7v-19C393.5,222.9,390.9,220.1,386.8,220.1z M426.7,321.5H416v-18.9c0-4.7-2.6-7.4-6.6-7.4
	s-6.7,2.6-6.7,7.4v18.9H392v-34.9h10.7v4.7c2.1-3,5.9-5,10.6-5c8.1,0,13.4,5.5,13.4,14.8V321.5z M448.2,322.2c-9.4,0-15.6-5.2-16-12
	h10.5c0.3,2.5,2.5,4,5.3,4c2.7,0,4.2-1.3,4.2-2.9c0-5.6-19-1.6-19-14.3c0-6,5.1-10.8,14.2-10.8c9,0,14.1,5,14.7,11.8h-9.9
	c-0.3-2.3-2.1-3.9-5.1-3.9c-2.5,0-3.9,1-3.9,2.7c0,5.6,18.9,1.6,19,14.6C462.4,317.6,457.1,322.2,448.2,322.2z M486.4,295.6h-5.6
	v26.1h-10.7v-26.1h-4v-8.9h3.9v-1c0-9.1,5.6-13.7,16.3-13v9.1c-4.2-0.3-5.6,1-5.6,4.7v0.3h5.7V295.6z M524.2,306.6h-24.2
	c0.4,4.6,3.1,6.6,6.7,6.6c3,0,4.7-1.6,5.6-3.4h11.3c-1.7,6.9-7.8,12.2-16.5,12.2c-10.3,0-17.6-6.9-17.6-18c0-11.1,7.3-18,17.6-18
	c10.2,0,17.3,6.8,17.3,17.3C524.3,304.6,524.3,305.6,524.2,306.6z M551.7,297.7h-3c-5.1,0-7.9,1.7-7.9,7.8v16.2H530v-34.9h10.7v5.9
	c2.5-3.7,6.3-6.2,10.9-6.2V297.7z M507,294.8c-3.6,0-6.3,2.1-6.9,6h13.4C513.5,297,510.5,294.8,507,294.8z M365.9,295.6
	c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6C373.5,298.8,369.9,295.6,365.9,295.6z M343.3,237.8
	c4,0,7.7-3.1,7.7-8.6s-3.7-8.7-7.7-8.7s-7.7,3-7.7,8.6S339.3,237.8,343.3,237.8z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7
	C310,230,307.8,228.2,304.2,228.2z M308.9,216c0-3.1-2-4.7-5.5-4.7h-7v9.2h7C307,220.5,308.9,219,308.9,216z M343.3,220.5
	c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6
	C308.9,212.8,307,211.3,303.5,211.3z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7C310,230,307.8,228.2,304.2,228.2z
	 M365.9,295.6c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6C373.5,298.8,369.9,295.6,365.9,295.6z M365.9,295.6
	c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6C373.5,298.8,369.9,295.6,365.9,295.6z M343.3,220.5
	c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7
	C310,230,307.8,228.2,304.2,228.2z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6C308.9,212.8,307,211.3,303.5,211.3z M343.3,220.5
	c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6
	C308.9,212.8,307,211.3,303.5,211.3z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7C310,230,307.8,228.2,304.2,228.2z
	 M365.9,295.6c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6C373.5,298.8,369.9,295.6,365.9,295.6z M365.9,295.6
	c-4,0-7.7,3-7.7,8.6c0,5.6,3.7,8.7,7.7,8.7c4,0,7.7-3.1,7.7-8.6C373.5,298.8,369.9,295.6,365.9,295.6z M343.3,220.5
	c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7
	C310,230,307.8,228.2,304.2,228.2z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6C308.9,212.8,307,211.3,303.5,211.3z M343.3,220.5
	c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6
	C308.9,212.8,307,211.3,303.5,211.3z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7C310,230,307.8,228.2,304.2,228.2z
	 M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z M304.2,228.2h-7.8v9.6h7.8
	c3.5,0,5.6-1.6,5.6-4.7C310,230,307.8,228.2,304.2,228.2z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6
	C308.9,212.8,307,211.3,303.5,211.3z M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z
	 M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6C308.9,212.8,307,211.3,303.5,211.3z M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7
	C310,230,307.8,228.2,304.2,228.2z M343.3,220.5c-4,0-7.7,3-7.7,8.6s3.7,8.7,7.7,8.7s7.7-3.1,7.7-8.6S347.4,220.5,343.3,220.5z
	 M304.2,228.2h-7.8v9.6h7.8c3.5,0,5.6-1.6,5.6-4.7C310,230,307.8,228.2,304.2,228.2z M303.5,211.3h-7v9.2h7c3.5,0,5.5-1.6,5.5-4.6
	C308.9,212.8,307,211.3,303.5,211.3z"/>
</svg>
';
    }

    public function getViewName()
    {
        return "checkout.banktransfer";
    }

    public function initialize()
    {
    }

    public function render()
    {
        return view('checkout.banktransfer')->render();
    }

    public function processPayment($transaction)
    {
        $request = $this->request;
        $plan_id = $request->plan_id;
        if ($plan_id == 0) {
            $plan = ads_plan();
        } else {
            $plan = Plan::find($request->plan_id); //get from plan db
        }

        if ($request->type == "yearly") {
            $amount = $plan->yearly_price;
            $var_type = "addAnnualPlan";
        } else {
            $amount = $plan->monthly_price;
            $var_type = "addMonthlyPlan";
        }


        try {

            $transaction->transaction_id = $request->transaction_id; // update the transaction id for the database
            $transaction->update();
            return redirect()->route("payments.pending", $transaction->id);
        } catch (\Exception $e) {
            return redirect()->back()->withError($e->getMessage());
        }
    }

    public function verifyPayment($transaction, $request): bool
    {
        return true;
    }
}
