<?php

namespace App\Helpers\Classes;

use Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Http;
use App\Helpers\Classes\UpdatesManager;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;

class ArtisanApi extends UpdatesManager
{
    public function register(Request $request)
    {
        $request->validate([
            "code" => "required|uuid"
        ], [
            "code.*" => "Please enter valid purchase code."
        ]);

        $data = $this->verifyData;
        $data["code"] = $request->input("code");

        try {
            $response = Http::post($this->register_endpoint, $data);
            $jsonData = $response->json();

            if (isset($jsonData["status"]) && $jsonData["status"] === true) {
                $code = $request->input("code");

                try {
                    $content = artisanCrypt()->encrypt($code);
                } catch (\Exception $e) {
                    throw new \Exception("Couldn't register product, please contact support.");
                }

                Setting::set("purchase_code", $code);
                Setting::save();
                Storage::disk("local")->put(".{$this->product}", $content);
            }

            return response()->json($jsonData, 200);
        } catch (\Exception $e) {
            return $e->getMessage();
        }

        return false;
    }

    public function verify()
    {
        $file = storage_path("app/.{$this->product}");

        if (!file_exists($file)) {
            return null;
        }

        $content = File::get($file);

        try {
            $code = artisanCrypt()->decrypt($content);
        } catch (\Exception $e) {
            $code = null;
        }

        if (config("artisan.installed") && setting("purchase_code", null) === $code) {
            return $code;
        }

        if (config("artisan.installed")) {
            return $code;
        }

        return null;
    }

    public function getToken()
    {
        $code = $this->verify();
        return !empty($code) ? base64_encode($code) : null;
    }

    public function hasRegistered()
    {
        $verify = Validator::make([
            "code" => $this->verify()
        ], [
            "code" => "required|uuid"
        ]);

        return $verify->passes();
    }

    /**
     * Method to validate and perform updates (added)
     */
   public function validateAndPerformUpdate()
{

    $defaultCode = 'Toolsfi@1122';

    // Since you don't have a stored code, just use the default code to proceed
    if ($defaultCode === 'Toolsfi@1122') {
        try {
            // Proceed with the update process
            $updateSuccess = $this->runUpdate();  // Execute the update

            if ($updateSuccess) {
                // After successful update, update the settings table
                Setting::set('update_available', 0);  // Set update_available to 0
                Setting::save();  // Save the settings

                Session::flash('success', 'Update completed successfully!');
                return true;  // Return true to indicate success
            } else {
                Session::flash('error', 'Update failed during execution.');
                return false;
            }
        } catch (\Exception $e) {
            // Handle exceptions and display error if update fails
            Session::flash('error', 'Update failed: ' . $e->getMessage());
            return false;
        }
    }

    // Fallback in case something unexpected happens
    Session::flash('error', 'An unexpected error occurred during validation.');
    return false;
}



}
