<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $pages = $this->getPages();
        if (DB::table('pages')->count() == 0) {

            foreach ($pages as $data) {
                $page = User::first()->pages()->create([
                    'published' => true,
                ]);

                $page->fill(['en' => $data['en']]);
                $page->save();
            }
        }
    }


    protected function getPages()
    {
        $pages = array(
            array('published' => '1', 'settings' => NULL),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "1", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "1", "dark_header": null, "header_width": "yes", "header_shadow": "yes", "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": "yes", "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "1", "breadcrumbs": "1", "dark_header": null, "header_width": "yes", "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "yes", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": "no", "header_width": "yes", "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "yes", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "no", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": null, "header_shadow": null, "sticky_header": null, "floating_header": "yes", "header_background_color": null}'),
            array('published' => '1', 'settings' => '{"show_title": "0", "breadcrumbs": "0", "dark_header": null, "header_width": "no", "header_shadow": null, "sticky_header": null, "floating_header": "yes", "header_background_color": null}')
        );

        $page_translations = array(
            array('title' => 'Privacy Policy', 'slug' => 'privacy-policy', 'content' => 'Privacy policy content goes here...', 'styles' => NULL, 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => NULL, 'meta_description' => NULL, 'og_title' => NULL, 'og_description' => NULL),
            array('title' => 'Home', 'slug' => 'home', 'content' => '<section class="section section-xxxl banner d-flex align-items-center"><div class="container"><div class="row justify-contant-center align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="content"><h2>
                                    Tools to Make <br/><span class="text-secondary">Everything</span> Simples
                                </h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
                                    incididunt
                                    ut labore et dolore magna aliqua. </p><button role="button" class="btn btn-secondary rounded-pill btn-lg px-4 me-2 mb-2 mb-md-0">Get Started Free</button><button role="button" class="btn btn-dark rounded-pill btn-lg px-4">Explore All PDF Tools</button></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12 text-center text-lg-end mt-3 mt-lg-0"><svg width="434" height="434" viewBox="0 0 434 434" fill="none" xmlns="http://www.w3.org/2000/svg" class="img-fluid"><circle cx="217" cy="217" r="216.5" stroke="#017FFA" stroke-dasharray="2 2" class="banner-elem-1"></circle><circle cx="217" cy="217" r="144.5" stroke="#017FFA" stroke-dasharray="2 2" class="banner-elem-2"></circle><circle cx="217" cy="217" r="91" fill="#4040cc" class="banner-elem-3">
                                </circle><circle cx="217" cy="217" r="90.5" stroke="#017FFA" stroke-dasharray="2 2" class="banner-elem-4"></circle><circle cx="375.5" cy="66.5" r="46.5" fill="#FFB700" class="banner-elem-5">
                                </circle><circle cx="337" cy="397" r="37" fill="#D61C4E" class="banner-elem-6">
                                </circle><circle cx="44" cy="89" r="37" fill="#36D5A8" class="banner-elem-7">
                                </circle><circle cx="126" cy="325" r="37" fill="#0055FF" class="banner-elem-8">
                                </circle><g clip-path="url(#clip0_80_213)"><path d="M267.893 231.952C266.931 239.179 261.374 244.426 250.955 243.034C244.33 242.124 237.704 236.288 233.804 231.899C228.621 232.434 218.309 233.665 214.302 234.736C210.668 235.753 202.173 239.393 197.257 241.588C196.776 247.477 194.853 255.828 190.204 260.486C182.777 267.927 175.19 267.178 170.007 261.985C164.824 256.792 164.076 249.19 171.503 241.749C176.633 236.61 186.25 235.004 192.074 234.736C195.12 230.293 199.982 222.53 203.241 214.875C206.127 207.969 207.569 200.849 208.157 196.62C204.417 192.123 199.875 184.949 199.875 178.364C199.875 167.818 205.806 163 213.073 163C220.339 163 226.27 167.872 226.27 178.364C226.27 184.36 222.316 190.945 218.683 195.495C220.072 199.082 222.904 205.399 226.27 209.896C230.171 215.142 234.338 219.318 236.85 221.62C241.765 218.783 248.551 215.999 254.375 216.748C264.794 218.194 268.801 224.725 267.893 231.952ZM253.253 227.027C250.261 226.278 246.147 228.205 246.04 228.526C245.986 228.794 248.765 232.434 251.757 233.183C254.749 233.933 256.459 232.862 256.886 231.149C257.314 229.436 256.192 227.723 253.253 227.027ZM213.554 209.521C213.554 209.521 211.684 215.571 210.829 217.498C209.546 220.335 204.951 228.472 204.844 228.794C205.058 228.687 212.164 226.063 214.569 225.367C216.973 224.672 224.293 223.012 224.293 223.012C224.293 223.012 219.324 217.819 217.882 215.999C216.653 214.5 213.554 209.521 213.554 209.521ZM213.073 186.127C213.34 186.127 216.225 182.54 216.225 179.435C216.225 176.384 214.836 174.938 213.073 174.938C211.31 174.938 209.92 176.33 209.92 179.435C209.92 182.54 212.699 186.127 213.073 186.127ZM179.197 248.227C177.06 250.368 177.06 252.402 178.236 253.634C179.465 254.865 181.495 254.865 183.632 252.67C185.769 250.529 186.357 245.978 186.09 245.764C185.93 245.55 181.388 246.032 179.197 248.227Z" fill="white" class="banner-elem-9"></path></g><path d="M49.1266 81.7906C49.2531 81.5891 48.3109 80.7078 47.0078 79.8125C45.7094 78.9125 44.5422 78.3453 44.3969 78.5375L34.9188 93.1063L34.45 93.7953C34.6844 95.0469 37.15 97.0297 39.1609 96.9219L39.6812 96.186L49.1266 81.7906ZM46.3328 79.8735C46.3563 79.836 46.5672 79.9391 46.8063 80.1031C47.0406 80.2672 47.2141 80.4266 47.1906 80.4641C47.1672 80.5016 46.9516 80.3985 46.7172 80.2344C46.4781 80.0656 46.3094 79.9063 46.3328 79.8735ZM55 99.5H40.1219L42.4328 96.125H55V99.5ZM34.0938 94.4422L34 99.486L38.8047 97.5688C38.1109 97.4094 36.9156 97.2031 35.9172 96.5235C34.9984 95.9 34.4688 94.9813 34.0938 94.4422Z" fill="white" class="banner-elem-10"></path><path d="M388 56.5C388 54.0125 386.013 52 383.558 52C381.102 52 379.116 54.0125 379.116 56.5C379.116 58.2812 380.134 59.8188 381.621 60.55C381.065 63.0813 379.572 63.625 375.944 64.4C374.186 64.775 372.07 65.225 370.299 66.4062V60.5875C371.823 59.875 372.884 58.3125 372.884 56.5C372.884 54.0125 370.898 52 368.442 52C365.987 52 364 54.0125 364 56.5C364 58.2937 365.037 59.8438 366.542 60.5688V71.4312C365.037 72.1562 364 73.7062 364 75.5C364 77.9875 365.987 80 368.442 80C370.898 80 372.884 77.9875 372.884 75.5C372.884 73.8875 372.045 72.4688 370.78 71.675C370.892 71.4 371.181 70.4312 372.28 69.6437C373.403 68.8375 374.939 68.5125 376.716 68.1313C380.467 67.3313 384.576 66.325 385.409 60.575C385.409 60.575 385.464 60.5625 385.532 60.5312C386.994 59.7937 388 58.2688 388 56.5ZM368.442 53.8563C369.886 53.8563 371.052 55.0375 371.052 56.5C371.052 57.9625 369.886 59.1438 368.442 59.1438C366.998 59.1438 365.832 57.9625 365.832 56.5C365.832 55.0375 366.998 53.8563 368.442 53.8563ZM368.442 78.1437C366.998 78.1437 365.832 76.9625 365.832 75.5C365.832 74.0375 366.998 72.8563 368.442 72.8563C369.886 72.8563 371.052 74.0375 371.052 75.5C371.052 76.9625 369.886 78.1437 368.442 78.1437ZM383.558 59.1438C382.114 59.1438 380.948 57.9625 380.948 56.5C380.948 55.0375 382.114 53.8563 383.558 53.8563C385.002 53.8563 386.168 55.0375 386.168 56.5C386.168 57.9625 385.002 59.1438 383.558 59.1438ZM368.442 57.375C367.967 57.375 367.578 56.9812 367.578 56.5C367.578 56.0188 367.967 55.625 368.442 55.625C368.917 55.625 369.306 56.0188 369.306 56.5C369.306 56.9812 368.917 57.375 368.442 57.375ZM368.442 76.375C367.967 76.375 367.578 75.9813 367.578 75.5C367.578 75.0187 367.967 74.625 368.442 74.625C368.917 74.625 369.306 75.0187 369.306 75.5C369.306 75.9813 368.917 76.375 368.442 76.375Z" fill="white" class="banner-elem-11"></path><path d="M136.087 322.469H132.555V318.449C132.555 314.816 129.609 311.875 125.977 311.875C124.158 311.875 122.515 312.613 121.323 313.797C120.138 314.986 119.399 316.633 119.399 318.449V322.469H115.913L115.555 322.773V338.125H136.445V322.773L136.087 322.469ZM126.769 331.803V333.678C126.769 333.9 126.681 334.094 126.54 334.234C126.399 334.375 126.2 334.463 125.983 334.463C125.548 334.463 125.196 334.111 125.196 333.678V331.855C124.715 331.592 124.392 331.082 124.392 330.502C124.392 329.646 125.085 328.949 125.941 328.949C126.798 328.949 127.491 329.646 127.491 330.502C127.485 331.047 127.197 331.533 126.769 331.803ZM129.891 322.469H122.057V318.449C122.057 316.287 123.811 314.535 125.977 314.535C128.142 314.535 129.896 316.293 129.896 318.449V322.469H129.891Z" fill="white" class="banner-elem-12"></path><g clip-path="url(#clip1_80_213)"><path d="M341.091 390.766C340.58 390.766 340.167 390.361 340.167 389.858V381.969H327.598C326.064 381.969 324.826 383.186 324.826 384.693V408.307C324.826 409.814 326.064 411.031 327.598 411.031H346.396C347.93 411.031 349.168 409.814 349.168 408.307V390.766H341.091ZM329.329 389.446H333.365C333.987 389.446 334.486 389.937 334.486 390.548C334.486 391.16 333.987 391.65 333.365 391.65H329.329C328.707 391.65 328.208 391.16 328.208 390.548C328.208 389.937 328.707 389.446 329.329 389.446ZM344.566 406.629L329.323 406.514C328.707 406.508 328.208 406.018 328.208 405.413V405.4C328.208 404.789 328.707 404.298 329.329 404.298H344.572C345.194 404.298 345.693 404.789 345.693 405.4V405.528C345.693 406.139 345.188 406.629 344.566 406.629ZM328.208 400.859V400.726C328.208 400.115 328.707 399.624 329.329 399.624H344.572C345.194 399.624 345.693 400.115 345.693 400.726V400.859C345.693 401.471 345.194 401.961 344.572 401.961H329.329C328.707 401.961 328.208 401.471 328.208 400.859ZM328.208 396.179V396.046C328.208 395.434 328.707 394.944 329.329 394.944H344.572C345.194 394.944 345.693 395.434 345.693 396.046V396.179C345.693 396.791 345.194 397.281 344.572 397.281H329.329C328.707 397.281 328.208 396.791 328.208 396.179ZM342.102 381.969V387.987C342.102 388.49 342.514 388.895 343.026 388.895H349.168L342.102 381.969Z" fill="#F3F3F5" class="banner-elem-13"></path></g><defs><clipPath id="clip0_80_213"><rect width="102" height="103" fill="white" transform="translate(166 163)" class="banner-elem-14"></rect></clipPath><clipPath id="clip1_80_213"><rect width="26" height="31" fill="white" transform="translate(324 381)" class="banner-elem-15"></rect></clipPath></defs></svg></div></div></div></section><section class="section section-xl brands-container"><div class="container"><div class="row"><div class="col-md-12 text-center"><h2 class="section-heading">Over <span class="text-primary">15K</span> business growing with pdf tools</h2></div></div><div class="row row-cols-2 row-cols-md-3 row-cols-lg-5 justify-content-center featured-brands g-3"><div data-aos="fade-up" data-aos-delay="0" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="100" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="200" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="300" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="400" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div></div></div></section><section class="section section-lg"><div class="container"><div class="row"><div class="col-md-12"><x-shortcode-tools layout="style1"></x-shortcode-tools></div></div></div></section><section class="section section-xxxl free-tools"><div class="container"><div class="row justify-content-center align-items-center"><div class="col-md-12 col-lg-6 col-sm-12"><div class="title"><h2>Free PDF tools</h2><div class="page-divider bg-primary"></div><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
                                eiusmod
                                tempor incididunt
                                ut
                                labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation
                                ullamco
                                laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit
                                in
                                voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat
                                cupidatat
                                non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><a class="btn btn-primary rounded-pill px-4">Signup</a></div></div><div class="col-md-12 col-lg-6 col-sm-12 tools"><div class="row"><div class="col-md-6 col-sm-12"><div class="card active"><div class="card-body"><i class="lni lni-happy"></i><h6>Easy to use</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div><div class="card"><div class="card-body"><i class="lni lni-infinite"></i><h6>No limits</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div><div class="col-md-6 col-sm-12 card-down"><div class="card"><div class="card-body"><i class="lni lni-star-fill"></i><h6>Easy to use</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div><div class="card"><div class="card-body"><i class="lni lni-invention"></i><h6>No limits</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div></div></div></div></section><section class="section section-xxl tools-detail"><div class="container"><div class="tools-detail-wrap nav-active-bg bg-warning-subtle"><div class="row"><div class="col-md-12"><ul class="nav nav-pills flex-nav justify-content-lg-center"><li class="nav-item"><a data-bg="bg-warning-subtle" data-bs-toggle="tab" href="#featuredTab1" class="nav-link rounded-pill px-5 me-2 active">PDF
                                        Editor</a></li><li class="nav-item"><a data-bg="bg-success-subtle" data-bs-toggle="tab" href="#featuredTab2" class="nav-link rounded-pill px-5 me-2">Compress PDF</a></li><li class="nav-item"><a data-bg="bg-danger-subtle" data-bs-toggle="tab" href="#featuredTab3" class="nav-link rounded-pill px-5 me-2">Unlock PDF</a></li><li class="nav-item"><a data-bg="bg-info-subtle" data-bs-toggle="tab" href="#featuredTab4" class="nav-link rounded-pill px-5">Split PDF</a></li></ul><div class="tab-content"><div id="featuredTab1" class="tab-pane container fade show active"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>PDF Editor</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab2" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Compress PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-end"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab3" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Unlock PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-end"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab4" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Split PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-end"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div></div></div></div></div></div></section><section class="section section-xxxl testimonials"><div class="container"><div class="row"><div class="col-md-12"><div class="title text-center"><h2>Testimonials</h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt
                                ut labore et dolore magna aliqua.</p></div></div><div class="testimonials-slider"><div class="container"><div class="row justify-content-evenly"><div id="testimonials-carousel" class="swiper testimonials-carousel"><div class="swiper-wrapper"><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Missy Limana</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Ronne Waster</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Ronne Waster</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Hanna Lisem</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div></div><div class="swiper-button-prev empty"></div><div class="swiper-button-next empty"></div><div class="swiper-pagination empty"></div></div></div></div></div></div></div></section>', 'styles' => NULL, 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Home', 'meta_description' => NULL, 'og_title' => 'Home', 'og_description' => NULL),
            array('title' => 'Pricing', 'slug' => 'pricing', 'content' => '<section class="section section-lg"><div class="container"><div class="row"><div class="col-md-12"><x-shortcode-plans></x-shortcode-plans></div></div></div></section><section class="section section-xl high-volume"><div class="container"><div class="row align-items-center"><div class="col-12 col-lg-4 col-md-5 col-sm-12"><div class="title"><h2>High-volume processing for PDF-heavy industries</h2><p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Mollitia voluptate culpa, ut
                                odio optio amet magnam </p></div></div><div class="col-12 col-lg-8 col-md-7 col-sm-12"><div class="high-volume-swiper"><div class="container"><div class="row justify-content-evenly"><div class="high-volume-swiper-main"><div id="offers-carousel" class="swiper offers-carousel"><div class="swiper-wrapper"><div class="swiper-slide high-volume-item"><div class="card"><div class="card-body"><div class="icon"><i class="lni lni-world"></i></div><div class="content"><h4>Financial services</h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                                                    sed do eiusmod tempor incididunt ut
                                                                    labore et dolore magna aliqua. Lorem ipsum dolor sit
                                                                    amet, consectetur </p></div></div></div></div><div class="swiper-slide high-volume-item"><div class="card"><div class="card-body"><div class="icon"><i class="lni lni-target-revenue"></i></div><div class="content"><h4>Financial services</h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                                                    sed do eiusmod tempor incididunt ut
                                                                    labore et dolore magna aliqua. Lorem ipsum dolor sit
                                                                    amet, consectetur </p></div></div></div></div></div><div class="swiper-button-prev empty"></div><div class="swiper-button-next empty"></div><div class="swiper-pagination empty"></div></div></div></div></div></div></div></div></div></section><section class="section section-xxl"><div class="container"><div class="row"><div class="col-md-12"><x-shortcode-compare-plan-features></x-shortcode-compare-plan-features></div></div></div></section><section class="section section-lg"><div class="container"><div class="row row-cols-1 row-cols-lg-3 row-cols-md-2"><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-question-circle"></i><h3 class="fw-normal h5">How to use?</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero
                                            vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                                            consectetur
                                            convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-cup"></i><h3 class="fw-normal h5">Security and Privacy</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-world"></i><h3 class="fw-normal h5">Access from anywhere</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-checkmark-circle"></i><h3 class="fw-normal h5">Easy to use?</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero
                                            vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                                            consectetur
                                            convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-empty-file"></i><h3 class="fw-normal h5">Convert any Format</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-star-empty"></i><h3 class="fw-normal h5">You\'re in Good Company</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div></div></div></section>', 'styles' => NULL, 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Pricing', 'meta_description' => NULL, 'og_title' => 'Pricing', 'og_description' => NULL),
            array('title' => 'Contact Us', 'slug' => 'contact-us', 'content' => '<section class="section section-lg"><div class="container"><div class="row"><div class="col-md-12"><x-shortcode-contact layout="full"></x-shortcode-contact></div></div></div></section>', 'styles' => NULL, 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Contact Us', 'meta_description' => NULL, 'og_title' => 'Contact Us', 'og_description' => NULL),
            array('title' => 'Download File', 'slug' => 'download-file', 'content' => '<section class="section section-xxxl free-tools" id="ipjt"><div class="container"><div class="row justify-content-center align-items-center"><div class="col-md-12 col-lg-6 col-sm-12"><div class="title"><h2>Free PDF tools</h2><div class="page-divider bg-primary"></div><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
                                eiusmod
                                tempor incididunt
                                ut
                                labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation
                                ullamco
                                laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit
                                in
                                voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat
                                cupidatat
                                non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><a class="btn btn-primary rounded-pill px-4">Signup</a></div></div><div class="col-md-12 col-lg-6 col-sm-12 tools"><div class="row"><div class="col-md-6 col-sm-12"><div class="card active"><div class="card-body"><i class="lni lni-happy"></i><h6>Easy to use</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div><div class="card"><div class="card-body"><i class="lni lni-infinite"></i><h6>No limits</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div><div class="col-md-6 col-sm-12 card-down"><div class="card"><div class="card-body"><i class="lni lni-star-fill"></i><h6>Easy to use</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div><div class="card"><div class="card-body"><i class="lni lni-invention"></i><h6>No limits</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div></div></div></div></section><section class="section section-xxxl testimonials"><div class="container"><div class="row"><div class="col-md-12"><div class="title text-center"><h2>Testimonials</h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt
                                ut labore et dolore magna aliqua.</p></div></div><div class="testimonials-slider"><div class="container"><div class="row justify-content-evenly"><div id="testimonials-carousel" class="swiper testimonials-carousel"><div class="swiper-wrapper"><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Missy Limana</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Ronne Waster</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Hanna Lisem</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div></div><div class="swiper-button-prev empty"></div><div class="swiper-button-next empty"></div><div class="swiper-pagination empty"></div></div></div></div></div></div></div></section>', 'styles' => '#ipjt{background-color:#ffffff;}', 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Download File', 'meta_description' => NULL, 'og_title' => 'Download File', 'og_description' => NULL),
            array('title' => 'Checkout', 'slug' => 'checkout', 'content' => NULL, 'styles' => NULL, 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Checkout', 'meta_description' => NULL, 'og_title' => 'Checkout', 'og_description' => NULL),
            array('title' => 'Blog', 'slug' => 'blog', 'content' => '<section id="ia31" class="section section-0"><div class="container"><div class="row"><div class="col-md-12"><x-shortcode-blog layout="card-alternate" order="popular" posts="15" columns="2" id="i3ev" pagination="true" animation="zoom-in-up" duration="400"></x-shortcode-blog></div></div></div></section>', 'styles' => NULL, 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Blog', 'meta_description' => NULL, 'og_title' => 'Blog', 'og_description' => NULL),
            array('title' => 'Terms & conditions', 'slug' => 'terms-and-conditions', 'content' => NULL, 'styles' => NULL, 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Terms & conditions', 'meta_description' => NULL, 'og_title' => 'Terms & conditions', 'og_description' => NULL),
            array('title' => 'Checkout Success', 'slug' => 'checkout-success', 'content' => '<div id="i7wm" class="text-center py-5"><img src="/themes/echo/images/success.png" alt="Payment Successful" class="img-fluid"/><h1 id="ifvcv" class="text-success mt-5">Congratulations! Your Payment Was Successful
    </h1><p id="i5fgh" class="m-0">Thank you for choosing TruPDF for your PDF needs. We are delighted to inform you that your payment has been successfully processed.
    </p></div><section id="i8wn" class="section section-xxl bg-light"><div class="section-divider-top"></div><div class="container"><div class="row"><div id="i7kfv" class="col-md-12 fs-lg text-center"><h3 class="text-center h1">What\'s Next?</h3><ul class="list-unstyled text-dark"><li><b>Access Your Account: </b>You can now access your account and start enjoying our premium services immediately. Simply log in using your credentials.</li><li><b>Explore Our Features:</b> Discover the full range of features and tools available to you. Make the most out of your subscription by exploring our comprehensive suite of PDF Tools.</li><li><b>Get Started: </b>Dive right into using our platform. Whether you\'re managing projects, collaborating with team members, or accessing exclusive content, we\'re here to support you every step of the way.</li></ul><p class="text-center text-dark">We appreciate your business and look forward to serving you!</p></div></div></div></section><section id="ipuuc" class="section section-xxxl"><div class="container"><div class="row"><div class="col-md-12"><x-shortcode-tools layout="style3" id="ianuh"></x-shortcode-tools></div></div></div></section>', 'styles' => '.section.section-xxxl{--style-top:23;--fill-top:#f4f7f9;--zindex-top:1;--height-top:157px;--background-top:url(data:image/svg+xml;base64,PHN2ZyBmaWxsPSIjZjRmN2Y5IiBoZWlnaHQ9IjE1N3B4IiB3aWR0aD0iMTAwJSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSIgdmlld0JveD0iMCAwIDEyODAgMTQwIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjxwYXRoIGQ9Ik0wIDUxLjc2YzM2LjIxLTIuMjUgNzcuNTctMy41OCAxMjYuNDItMy41OCAzMjAgMCAzMjAgNTcgNjQwIDU3IDI3MS4xNSAwIDMxMi41OC00MC45MSA1MTMuNTgtNTMuNFYwSDB6IiBmaWxsLW9wYWNpdHk9Ii4zIi8+PHBhdGggZD0iTTAgMjQuMzFjNDMuNDYtNS42OSA5NC41Ni05LjI1IDE1OC40Mi05LjI1IDMyMCAwIDMyMCA4OS4yNCA2NDAgODkuMjQgMjU2LjEzIDAgMzA3LjI4LTU3LjE2IDQ4MS41OC04MFYwSDB6IiBmaWxsLW9wYWNpdHk9Ii41Ii8+PHBhdGggZD0iTTAgMHYzLjRDMjguMiAxLjYgNTkuNC41OSA5NC40Mi41OWMzMjAgMCAzMjAgODQuMyA2NDAgODQuMyAyODUgMCAzMTYuMTctNjYuODUgNTQ1LjU4LTgxLjQ5VjB6Ii8+PC9zdmc+);--background-size-top:100% 157px;--transform-top:scale(1, 1);background-position-x:center;background-position-y:bottom;}', 'scripts' => NULL, 'excerpt' => 'Checkout Success', 'meta_title' => 'Checkout Success', 'meta_description' => NULL, 'og_title' => 'Checkout Success', 'og_description' => NULL),
            array('title' => 'Checkout Pending', 'slug' => 'checkout-pending', 'content' => '<div id="i7wm" class="text-center py-5"><img src="/themes/echo/images/pending.png" alt="Payment Successful" id="ipzc" class="img-fluid"/><h1 id="ifvcv" class="mt-5">Complete Your Purchase</h1><p id="i5fgh" class="m-0">We\'re thrilled that you\'ve decided to take the next step in unlocking the full potential of our platform. <br/>You\'re just one step away from accessing all the powerful features and tools that will revolutionize the way you do business.</p></div><section id="i8wn" class="section section-xxl bg-light"><div class="section-divider-top">
    </div><div class="container"><div class="row"><div id="i7kfv" class="col-md-12 fs-lg text-center"><h3 class="text-center h1">Your Pending Checkout</h3><p id="i101j" class="text-center text-dark">Thank you for initiating the checkout process. At this stage, your order is pending finalization. <br/></p><p>Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.</p></div></div></div></section><section class="section section-lg"><div class="container"><div class="row"><div class="col-md-12 fs-lg text-center"><h3 class="text-center h1">Have Questions?</h3><p class="text-center text-dark">If you encounter any issues during the checkout process or have questions about our services, our dedicated support team is here to assist you.<br/></p></div></div><div class="row"><div class="col-md-12"><x-shortcode-contact layout="full"></x-shortcode-contact></div></div></div></section>', 'styles' => NULL, 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Checkout Pending', 'meta_description' => NULL, 'og_title' => 'Checkout Pending', 'og_description' => NULL),
            array('title' => 'Checkout Cancelled', 'slug' => 'checkout-cancelled', 'content' => '<div id="i7wm" class="text-center py-5"><img src="/themes/echo/images/cancelled.png" alt="Payment Successful" id="ipzc" class="img-fluid"/><h1 id="ifvcv" class="mt-5">We\'re Here to Assist You</h1><p id="i5fgh" class="m-0">We understand that sometimes plans change, and we\'re here to support you every step of the way. <br/>Although your checkout process was cancelled, we\'re committed to ensuring you have a seamless experience with TruPDF.</p></div><section id="i8wn" class="section section-xxl bg-light"><div class="section-divider-top">
    </div><div class="container"><div class="row"><div id="i7kfv" class="col-md-12 fs-lg text-center"><h3 class="text-center h1">What Happens Next?</h3><p>If you encountered any issues during the checkout process or have
questions about our services, our dedicated support team is ready to
assist you. </p></div><div class="col-md-12"><x-shortcode-contact layout="full"></x-shortcode-contact></div></div></div></section>', 'styles' => NULL, 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Checkout Cancelled', 'meta_description' => NULL, 'og_title' => 'Checkout Cancelled', 'og_description' => NULL),
            array('title' => 'Homepage One', 'slug' => 'homepage-one', 'content' => '<section id="homepage-one-header" class="section d-flex align-items-center section-0 text-white"><div class="container"><div class="row justify-contant-center align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="content"><h1 id="iu63" class="text-white">Tools to Make <br/><span id="igmm" class="text-dark"><b id="ifmky" class="text-white border-bottom"><span>PDF</span></b></span> Easy!</h1><p class="fs-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam
elit lacus, id scelerisque mauris luctus eu. Nullam ac pharetra arcu.
Donec congue pretium est, a volutpat ante pharetra ac. Sed scelerisque
mauris vel enim finibus auctor. </p><button role="button" class="btn btn-secondary rounded-pill btn-lg px-4 me-2 mb-2 mb-md-0">Get Started Free</button><button role="button" class="btn btn-dark rounded-pill btn-lg px-4">Explore All PDF Tools</button><p id="imdwe" class="mt-3">Lorem ipsum dolor sit amet, consectetur adipiscing elit. <br/></p></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12 text-center text-lg-end mt-3 mt-lg-0"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" id="header-img" class="img-fluid"/></div></div></div><div class="section-divider-bottom"></div></section><section class="top-categories section section-xxxl"><div class="container"><div class="row"><div class="title text-center"><h2>Top Categories</h2><p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Reprehenderit, deserunt
                            molestias. Sapiente nesciunt accusamus minus, nemo iure natus.</p></div></div><div class="row"><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="/themes/echo/images/icons/html-to-pdf.svg" alt="pdf to excel" id="i5cw6" class="img-fluid"/></div><div class="content"><h4>PDF to Word</h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="/themes/echo/images/icons/png-pdf.svg" alt="merge pdf" id="ivh3k" class="img-fluid"/></div><div class="content"><h4>PDF to Word</h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="/themes/echo/images/icons/pdf-watermark-remover.svg" alt="pdf jpg" id="iiihr" class="img-fluid"/></div><div class="content"><h4>PDF to Word</h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="/themes/echo/images/icons/protect-pdf.svg" alt="compress pdf" id="iy8wl" class="img-fluid"/></div><div class="content"><h4>PDF to Word</h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div></div></div></section><section id="ijkxv" class="section brands-container bg-primary text-white section-xxxl"><div class="section-divider-top"></div><div id="iz05j" class="container"><div class="row"><div class="col-md-12 text-center"><h2 id="ilgrw" class="section-heading text-white">Over <span id="ivlfg" class="text-secondary">15K</span> business growing with pdf tools</h2></div></div><div class="row row-cols-2 row-cols-md-3 row-cols-lg-5 justify-content-center featured-brands g-3"><div data-aos="fade-up" data-aos-delay="0" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="100" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="200" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="300" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="400" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div></div></div><div class="section-divider-bottom"></div></section><section id="is1983" class="section section-xxxl"><div class="container"><div class="row"><div class="col"><h3 class="text-center h1 fw-semibold">Why Choose TruPDF?<br/></h3><p id="i1jpzr" class="text-center mb-5">Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.</p></div></div><div class="row row-cols-1 row-cols-lg-3 row-cols-md-2"><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-question-circle"></i><h3 class="fw-semibold h5">How to use?</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero
                                            vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                                            consectetur
                                            convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-cup"></i><h3 class="fw-semibold h5">Security and Privacy</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-world"></i><h3 class="fw-semibold h5">Access from anywhere</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-checkmark-circle"></i><h3 class="fw-semibold h5">Easy to use?</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero
                                            vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                                            consectetur
                                            convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-empty-file"></i><h3 class="fw-semibold h5">Convert any Format</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-star-empty"></i><h3 class="fw-semibold h5">You\'re in Good Company</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div></div></div></section><section id="ijsnrc" class="section section-0"><div class="section-divider-top"></div><div class="section-divider-bottom"></div></section><section class="section section-lg"><div class="container"><div class="row"><div class="col-md-6 align-self-center"><h1>Manage Documents in One Place</h1><p class="fs-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam
elit lacus, id scelerisque mauris luctus eu. Nullam ac pharetra arcu.
Donec congue pretium est, a volutpat ante pharetra ac. Sed scelerisque
mauris vel enim finibus auctor. Duis commodo pellentesque dolor, cursus
pulvinar risus efficitur eu. Nullam mauris justo.</p></div><div class="col-md-6"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" class="img-fluid"/></div></div></div></section><section id="iu2vvy" class="section section-xxxl"><div class="container"><div class="row"><div class="col-md-6"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" class="img-fluid"/></div><div class="col-md-6 align-self-center"><h1>Manage Documents in One Place</h1><p class="fs-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam
elit lacus, id scelerisque mauris luctus eu. Nullam ac pharetra arcu.
Donec congue pretium est, a volutpat ante pharetra ac. Sed scelerisque
mauris vel enim finibus auctor. Duis commodo pellentesque dolor, cursus
pulvinar risus efficitur eu. Nullam mauris justo.</p></div></div></div></section><section id="ik0t3s" class="section section-lg"><div class="container"><div class="row"><div class="col-md-6 align-self-center"><h1>Manage Documents in One Place</h1><p class="fs-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam
elit lacus, id scelerisque mauris luctus eu. Nullam ac pharetra arcu.
Donec congue pretium est, a volutpat ante pharetra ac. Sed scelerisque
mauris vel enim finibus auctor. Duis commodo pellentesque dolor, cursus
pulvinar risus efficitur eu. Nullam mauris justo.</p></div><div class="col-md-6"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" class="img-fluid"/></div></div></div></section><section id="call-to-action" class="section try-pdf section-xl"><div class="container"><div data-aos-duration="" data-aos="" data-aos-anchor-placement="top-center" id="ilbh26" class="wrap"><div class="row align-items-center"><div class="col-12 col-lg-9 col-md-12 col-sm-12"><div class="row"><div class="col-md-9"><div class="title"><h1>Try PDF tools and see for yourself </h1><p>Try it for free Lorem, ipsum dolor sit amet consectetur adipisicing elit.
                                            Aliquam rem
                                            voluptatibus doloremque saepe, ex dolor quasi at fugiat quis pariatur
                                            dolorum nulla,
                                            autem, dicta architecto. </p></div></div></div></div><div class="col-12 col-lg-3 col-md-12 col-sm-12 d-grid"><a href="#" class="btn btn-light rounded-pill btn-lg px-4">Try for free</a></div></div></div></div></section><section id="injr4c" class="section border-top section-xxxl"><div class="container"><div class="row"><div class="col-md-12"><x-shortcode-tools layout="style3" id="ia8a4d"></x-shortcode-tools></div></div></div></section>', 'styles' => '#homepage-one-header{background-repeat:no-repeat;background-position-x:center;background-position-y:center;background-attachment:scroll;background-size:cover;background-image:url("/themes/echo/images/header-bg.svg");--style-bottom:9;--fill-bottom:#ffffff;--zindex-bottom:1;--height-bottom:100px;--background-bottom:url(data:image/svg+xml;base64,PHN2ZyBmaWxsPSIjZmZmZmZmIiBoZWlnaHQ9IjEwMHB4IiB3aWR0aD0iMTAwJSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSIgdmlld0JveD0iMCAwIDEyODAgMTQwIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjxwYXRoIGQ9Ik0xMjgwIDE0MFYwUzk5My40NiAxNDAgNjQwIDEzOSAwIDAgMCAwdjE0MHoiLz48L3N2Zz4=);--background-size-bottom:100% 100px;--transform-bottom:scale(1, 1);min-height:750px;}#header-img{border-top-left-radius:1rem;border-top-right-radius:1rem;border-bottom-right-radius:1rem;border-bottom-left-radius:1rem;}#ijkxv{--style-bottom:24;--fill-bottom:#ffffff;--zindex-bottom:1;--height-bottom:100px;--background-bottom:url(data:image/svg+xml;base64,PHN2ZyBmaWxsPSIjZmZmZmZmIiBoZWlnaHQ9IjEwMHB4IiB3aWR0aD0iMTAwJSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSIgdmlld0JveD0iMCAwIDEyODAgMTQwIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjxwYXRoIGQ9Ik0xMjgwIDg2Yy0xOS45LTE3LjIxLTQwLjA4LTM5LjY5LTc5Ljg5LTM5LjY5LTU3LjQ5IDAtNTYuOTMgNDYuNTktMTE1IDQ2LjU5LTUzLjYxIDAtNTkuNzYtMzkuNjItMTE1LjYtMzkuNjJDOTIzLjcgNTMuMjcgOTI0LjI2IDg3IDg1My44OSA4N2MtODkuMzUgMC03OC43NC04Ny0xODguMi04N0M1NTQgMCA1NDMuOTUgMTIxLjggNDIzLjMyIDEyMS44Yy0xMDAuNTIgMC0xMTcuODQtNTQuODgtMTkxLjU2LTU0Ljg4LTc3LjA2IDAtMTAwIDQ4LjU3LTE1MS43NSA0OC41Ny00MCAwLTYwLTEyLjIxLTgwLTI5LjUxdjU0SDEyODB6Ii8+PC9zdmc+);--background-size-bottom:100% 100px;--transform-bottom:scale(1, 1);}#iz05j{padding-top:0px;padding-right:0px;padding-bottom:5rem;padding-left:0px;}#ilbh26{max-width:1020px;margin-top:0px;margin-right:auto;margin-bottom:0px;margin-left:auto;padding-top:3rem;padding-right:2rem;padding-bottom:3rem;padding-left:2rem;}', 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Homepage One', 'meta_description' => NULL, 'og_title' => 'Homepage One', 'og_description' => NULL),
            array('title' => 'Homepage Two', 'slug' => 'homepage-two', 'content' => '<section id="ii9sjz" class="section section-xxxl banner d-flex align-items-center bg-white"><div class="container"><div class="row justify-contant-center align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="content"><h2>
                                    Tools to Make <br/><span class="text-secondary">Everything</span> Simples
                                </h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
                                    incididunt
                                    ut labore et dolore magna aliqua. </p><button role="button" class="btn btn-secondary rounded-pill btn-lg px-4 me-2 mb-2 mb-md-0">Get Started Free</button><button role="button" class="btn btn-dark rounded-pill btn-lg px-4">Explore All PDF Tools</button></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12 text-center text-lg-end mt-3 mt-lg-0"><svg width="434" height="434" viewBox="0 0 434 434" fill="none" xmlns="http://www.w3.org/2000/svg"><circle cx="217" cy="217" r="216.5" stroke="#017FFA" stroke-dasharray="2 2" class="banner-elem-1"></circle><circle cx="217" cy="217" r="144.5" stroke="#017FFA" stroke-dasharray="2 2" class="banner-elem-2"></circle><circle cx="217" cy="217" r="91" fill="#4040cc" class="banner-elem-3">
                                </circle><circle cx="217" cy="217" r="90.5" stroke="#017FFA" stroke-dasharray="2 2" class="banner-elem-4"></circle><circle cx="375.5" cy="66.5" r="46.5" fill="#FFB700" class="banner-elem-5">
                                </circle><circle cx="337" cy="397" r="37" fill="#D61C4E" class="banner-elem-6">
                                </circle><circle cx="44" cy="89" r="37" fill="#36D5A8" class="banner-elem-7">
                                </circle><circle cx="126" cy="325" r="37" fill="#0055FF" class="banner-elem-8">
                                </circle><g clip-path="url(#clip0_80_213)"><path d="M267.893 231.952C266.931 239.179 261.374 244.426 250.955 243.034C244.33 242.124 237.704 236.288 233.804 231.899C228.621 232.434 218.309 233.665 214.302 234.736C210.668 235.753 202.173 239.393 197.257 241.588C196.776 247.477 194.853 255.828 190.204 260.486C182.777 267.927 175.19 267.178 170.007 261.985C164.824 256.792 164.076 249.19 171.503 241.749C176.633 236.61 186.25 235.004 192.074 234.736C195.12 230.293 199.982 222.53 203.241 214.875C206.127 207.969 207.569 200.849 208.157 196.62C204.417 192.123 199.875 184.949 199.875 178.364C199.875 167.818 205.806 163 213.073 163C220.339 163 226.27 167.872 226.27 178.364C226.27 184.36 222.316 190.945 218.683 195.495C220.072 199.082 222.904 205.399 226.27 209.896C230.171 215.142 234.338 219.318 236.85 221.62C241.765 218.783 248.551 215.999 254.375 216.748C264.794 218.194 268.801 224.725 267.893 231.952ZM253.253 227.027C250.261 226.278 246.147 228.205 246.04 228.526C245.986 228.794 248.765 232.434 251.757 233.183C254.749 233.933 256.459 232.862 256.886 231.149C257.314 229.436 256.192 227.723 253.253 227.027ZM213.554 209.521C213.554 209.521 211.684 215.571 210.829 217.498C209.546 220.335 204.951 228.472 204.844 228.794C205.058 228.687 212.164 226.063 214.569 225.367C216.973 224.672 224.293 223.012 224.293 223.012C224.293 223.012 219.324 217.819 217.882 215.999C216.653 214.5 213.554 209.521 213.554 209.521ZM213.073 186.127C213.34 186.127 216.225 182.54 216.225 179.435C216.225 176.384 214.836 174.938 213.073 174.938C211.31 174.938 209.92 176.33 209.92 179.435C209.92 182.54 212.699 186.127 213.073 186.127ZM179.197 248.227C177.06 250.368 177.06 252.402 178.236 253.634C179.465 254.865 181.495 254.865 183.632 252.67C185.769 250.529 186.357 245.978 186.09 245.764C185.93 245.55 181.388 246.032 179.197 248.227Z" fill="white" class="banner-elem-9"></path></g><path d="M49.1266 81.7906C49.2531 81.5891 48.3109 80.7078 47.0078 79.8125C45.7094 78.9125 44.5422 78.3453 44.3969 78.5375L34.9188 93.1063L34.45 93.7953C34.6844 95.0469 37.15 97.0297 39.1609 96.9219L39.6812 96.186L49.1266 81.7906ZM46.3328 79.8735C46.3563 79.836 46.5672 79.9391 46.8063 80.1031C47.0406 80.2672 47.2141 80.4266 47.1906 80.4641C47.1672 80.5016 46.9516 80.3985 46.7172 80.2344C46.4781 80.0656 46.3094 79.9063 46.3328 79.8735ZM55 99.5H40.1219L42.4328 96.125H55V99.5ZM34.0938 94.4422L34 99.486L38.8047 97.5688C38.1109 97.4094 36.9156 97.2031 35.9172 96.5235C34.9984 95.9 34.4688 94.9813 34.0938 94.4422Z" fill="white" class="banner-elem-10"></path><path d="M388 56.5C388 54.0125 386.013 52 383.558 52C381.102 52 379.116 54.0125 379.116 56.5C379.116 58.2812 380.134 59.8188 381.621 60.55C381.065 63.0813 379.572 63.625 375.944 64.4C374.186 64.775 372.07 65.225 370.299 66.4062V60.5875C371.823 59.875 372.884 58.3125 372.884 56.5C372.884 54.0125 370.898 52 368.442 52C365.987 52 364 54.0125 364 56.5C364 58.2937 365.037 59.8438 366.542 60.5688V71.4312C365.037 72.1562 364 73.7062 364 75.5C364 77.9875 365.987 80 368.442 80C370.898 80 372.884 77.9875 372.884 75.5C372.884 73.8875 372.045 72.4688 370.78 71.675C370.892 71.4 371.181 70.4312 372.28 69.6437C373.403 68.8375 374.939 68.5125 376.716 68.1313C380.467 67.3313 384.576 66.325 385.409 60.575C385.409 60.575 385.464 60.5625 385.532 60.5312C386.994 59.7937 388 58.2688 388 56.5ZM368.442 53.8563C369.886 53.8563 371.052 55.0375 371.052 56.5C371.052 57.9625 369.886 59.1438 368.442 59.1438C366.998 59.1438 365.832 57.9625 365.832 56.5C365.832 55.0375 366.998 53.8563 368.442 53.8563ZM368.442 78.1437C366.998 78.1437 365.832 76.9625 365.832 75.5C365.832 74.0375 366.998 72.8563 368.442 72.8563C369.886 72.8563 371.052 74.0375 371.052 75.5C371.052 76.9625 369.886 78.1437 368.442 78.1437ZM383.558 59.1438C382.114 59.1438 380.948 57.9625 380.948 56.5C380.948 55.0375 382.114 53.8563 383.558 53.8563C385.002 53.8563 386.168 55.0375 386.168 56.5C386.168 57.9625 385.002 59.1438 383.558 59.1438ZM368.442 57.375C367.967 57.375 367.578 56.9812 367.578 56.5C367.578 56.0188 367.967 55.625 368.442 55.625C368.917 55.625 369.306 56.0188 369.306 56.5C369.306 56.9812 368.917 57.375 368.442 57.375ZM368.442 76.375C367.967 76.375 367.578 75.9813 367.578 75.5C367.578 75.0187 367.967 74.625 368.442 74.625C368.917 74.625 369.306 75.0187 369.306 75.5C369.306 75.9813 368.917 76.375 368.442 76.375Z" fill="white" class="banner-elem-11"></path><path d="M136.087 322.469H132.555V318.449C132.555 314.816 129.609 311.875 125.977 311.875C124.158 311.875 122.515 312.613 121.323 313.797C120.138 314.986 119.399 316.633 119.399 318.449V322.469H115.913L115.555 322.773V338.125H136.445V322.773L136.087 322.469ZM126.769 331.803V333.678C126.769 333.9 126.681 334.094 126.54 334.234C126.399 334.375 126.2 334.463 125.983 334.463C125.548 334.463 125.196 334.111 125.196 333.678V331.855C124.715 331.592 124.392 331.082 124.392 330.502C124.392 329.646 125.085 328.949 125.941 328.949C126.798 328.949 127.491 329.646 127.491 330.502C127.485 331.047 127.197 331.533 126.769 331.803ZM129.891 322.469H122.057V318.449C122.057 316.287 123.811 314.535 125.977 314.535C128.142 314.535 129.896 316.293 129.896 318.449V322.469H129.891Z" fill="white" class="banner-elem-12"></path><g clip-path="url(#clip1_80_213)"><path d="M341.091 390.766C340.58 390.766 340.167 390.361 340.167 389.858V381.969H327.598C326.064 381.969 324.826 383.186 324.826 384.693V408.307C324.826 409.814 326.064 411.031 327.598 411.031H346.396C347.93 411.031 349.168 409.814 349.168 408.307V390.766H341.091ZM329.329 389.446H333.365C333.987 389.446 334.486 389.937 334.486 390.548C334.486 391.16 333.987 391.65 333.365 391.65H329.329C328.707 391.65 328.208 391.16 328.208 390.548C328.208 389.937 328.707 389.446 329.329 389.446ZM344.566 406.629L329.323 406.514C328.707 406.508 328.208 406.018 328.208 405.413V405.4C328.208 404.789 328.707 404.298 329.329 404.298H344.572C345.194 404.298 345.693 404.789 345.693 405.4V405.528C345.693 406.139 345.188 406.629 344.566 406.629ZM328.208 400.859V400.726C328.208 400.115 328.707 399.624 329.329 399.624H344.572C345.194 399.624 345.693 400.115 345.693 400.726V400.859C345.693 401.471 345.194 401.961 344.572 401.961H329.329C328.707 401.961 328.208 401.471 328.208 400.859ZM328.208 396.179V396.046C328.208 395.434 328.707 394.944 329.329 394.944H344.572C345.194 394.944 345.693 395.434 345.693 396.046V396.179C345.693 396.791 345.194 397.281 344.572 397.281H329.329C328.707 397.281 328.208 396.791 328.208 396.179ZM342.102 381.969V387.987C342.102 388.49 342.514 388.895 343.026 388.895H349.168L342.102 381.969Z" fill="#F3F3F5" class="banner-elem-13"></path></g><defs><clipPath id="clip0_80_213"><rect width="102" height="103" fill="white" transform="translate(166 163)" class="banner-elem-14"></rect></clipPath><clipPath id="clip1_80_213"><rect width="26" height="31" fill="white" transform="translate(324 381)" class="banner-elem-15"></rect></clipPath></defs></svg></div></div></div><div class="section-divider-bottom"></div></section><section class="section section-lg"><div class="container"><div class="row"><div class="col-md-12"><x-shortcode-tools layout="style1"></x-shortcode-tools></div></div></div></section><section class="section section-xxxl stress-less"><div class="container"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12 order-md-2 order-sm-2 order-lg-1"><div class="title mb-5"><h2>Stress less about your PDF Workflow</h2><p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Earum illo soluta modi inventore
                                dolores nihil excepturi blanditiis ipsam?s</p></div><div class="icon-area"><div class="item"><i class="lni lni-calendar"></i><div class="content"><h6>Try it for 30 days no credit card required</h6><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p></div></div><div class="item"><i class="lni lni-timer"></i><div class="content"><h6>Watch your document processing time plummet</h6><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p></div></div></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12 order-md-1 order-sm-1 order-lg-2"><img src="/themes/echo/images/stress-less-img.svg" alt="stress less img" class="img-fluid"/></div></div></div></section><section id="is1983" class="section section-xxxl"><div class="container"><div class="row"><div class="col"><h3 class="text-center h1 fw-semibold">Why Choose TruPDF?
            <br/></h3><p id="i1jpzr" class="text-center mb-5">Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.
          </p></div></div><div class="row row-cols-1 row-cols-lg-3 row-cols-md-2"><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-question-circle">
              </i><h3 class="fw-semibold h5">How to use?
              </h3><p class="mb-0">
                Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                luctus
                libero
                vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                consectetur
                convallis.
              </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-cup">
              </i><h3 class="fw-semibold h5">Security and Privacy
              </h3><p class="mb-0">
                Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                luctus
                libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                arcu
                consectetur convallis.
              </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-world">
              </i><h3 class="fw-semibold h5">Access from anywhere
              </h3><p class="mb-0">
                Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                luctus
                libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                arcu
                consectetur convallis.
              </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-checkmark-circle">
              </i><h3 class="fw-semibold h5">Easy to use?
              </h3><p class="mb-0">
                Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                luctus
                libero
                vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                consectetur
                convallis.
              </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-empty-file">
              </i><h3 class="fw-semibold h5">Convert any Format
              </h3><p class="mb-0">
                Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                luctus
                libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                arcu
                consectetur convallis.
              </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-star-empty">
              </i><h3 class="fw-semibold h5">You\'re in Good Company
              </h3><p class="mb-0">
                Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                luctus
                libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                arcu
                consectetur convallis.
              </p></div></div></div></div></div></section><section class="section section-xxl tools-detail"><div class="container"><div class="tools-detail-wrap nav-active-bg bg-warning-subtle"><div class="row"><div class="col-md-12"><ul class="nav nav-pills justify-content-lg-center flex-nav"><li class="nav-item"><a data-bg="bg-warning-subtle" data-bs-toggle="tab" href="#featuredTab1" class="nav-link rounded-pill px-5 me-2 active">Merge PDF</a></li><li class="nav-item"><a data-bg="bg-success-subtle" data-bs-toggle="tab" href="#featuredTab2" class="nav-link rounded-pill px-5 me-2">Compress PDF</a></li><li class="nav-item"><a data-bg="bg-danger-subtle" data-bs-toggle="tab" href="#featuredTab3" class="nav-link rounded-pill px-5 me-2">Unlock PDF</a></li><li class="nav-item"><a data-bg="bg-info-subtle" data-bs-toggle="tab" href="#featuredTab4" class="nav-link rounded-pill px-5">Remove PDF Pages</a></li></ul><div class="tab-content"><div id="featuredTab1" class="tab-pane container fade show active"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Merge PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab2" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Compress PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab3" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Unlock PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab4" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Remove PDF Pages</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div></div></div></div></div></div></section><section class="section section-lg"><div class="container"><div class="row"><div class="col-md-6 align-self-center"><h1>Manage Documents in One Place
          </h1><p class="fs-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc aliquam
            elit lacus, id scelerisque mauris luctus eu. Nullam ac pharetra arcu.
            Donec congue pretium est, a volutpat ante pharetra ac. Sed scelerisque
            mauris vel enim finibus auctor. Duis commodo pellentesque dolor, cursus
            pulvinar risus efficitur eu. Nullam mauris justo.
          </p></div><div class="col-md-6"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" class="img-fluid"/></div></div></div></section><section class="section section-xl high-volume"><div class="container"><div class="row align-items-center"><div class="col-12 col-lg-4 col-md-5 col-sm-12"><div class="title"><h2>High-volume processing for PDF-heavy industries</h2><p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Mollitia voluptate culpa, ut
                                odio optio amet magnam </p></div></div><div class="col-12 col-lg-8 col-md-7 col-sm-12"><div class="high-volume-swiper"><div class="container"><div class="row justify-content-evenly"><div class="high-volume-swiper-main"><div id="offers-carousel" class="swiper offers-carousel"><div class="swiper-wrapper"><div class="swiper-slide high-volume-item"><div class="card"><div class="card-body"><div class="icon"><i class="lni lni-world"></i></div><div class="content"><h4>Financial services</h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                                                    sed do eiusmod tempor incididunt ut
                                                                    labore et dolore magna aliqua. Lorem ipsum dolor sit
                                                                    amet, consectetur </p></div></div></div></div><div class="swiper-slide high-volume-item"><div class="card"><div class="card-body"><div class="icon"><i class="lni lni-target-revenue"></i></div><div class="content"><h4>Financial services</h4><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit,
                                                                    sed do eiusmod tempor incididunt ut
                                                                    labore et dolore magna aliqua. Lorem ipsum dolor sit
                                                                    amet, consectetur </p></div></div></div></div></div><div class="swiper-button-prev empty"></div><div class="swiper-button-next empty"></div><div class="swiper-pagination empty"></div></div></div></div></div></div></div></div></div></section><section class="top-categories section section-xxxl"><div class="container"><div class="row"><div class="title text-center"><h2>Top Categories
          </h2><p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Reprehenderit, deserunt
            molestias. Sapiente nesciunt accusamus minus, nemo iure natus.
          </p></div></div><div class="row"><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="/themes/echo/images/icons/html-to-pdf.svg" alt="pdf to excel" id="i5cw6" class="img-fluid"/></div><div class="content"><h4>PDF to Word
                </h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.
                </p></div></div></div></div><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="/themes/echo/images/icons/png-pdf.svg" alt="merge pdf" id="ivh3k" class="img-fluid"/></div><div class="content"><h4>PDF to Word
                </h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.
                </p></div></div></div></div><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="/themes/echo/images/icons/pdf-watermark-remover.svg" alt="pdf jpg" id="iiihr" class="img-fluid"/></div><div class="content"><h4>PDF to Word
                </h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.
                </p></div></div></div></div><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="/themes/echo/images/icons/protect-pdf.svg" alt="compress pdf" id="iy8wl" class="img-fluid"/></div><div class="content"><h4>PDF to Word
                </h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.
                </p></div></div></div></div></div></div></section><section id="call-to-action" class="section try-pdf section-xl"><div class="container"><div data-aos-duration="" data-aos="" data-aos-anchor-placement="top-center" id="ilbh26" class="wrap"><div class="row align-items-center"><div class="col-12 col-lg-9 col-md-12 col-sm-12"><div class="row"><div class="col-md-9"><div class="title"><h1>Try PDF tools and see for yourself
                  </h1><p>Try it for free Lorem, ipsum dolor sit amet consectetur adipisicing elit.
                    Aliquam rem
                    voluptatibus doloremque saepe, ex dolor quasi at fugiat quis pariatur
                    dolorum nulla,
                    autem, dicta architecto.
                  </p></div></div></div></div><div class="col-12 col-lg-3 col-md-12 col-sm-12 d-grid"><a href="#" class="btn btn-light rounded-pill btn-lg px-4">Try for free</a></div></div></div></div></section><section class="section section-xxxl testimonials"><div class="container"><div class="row"><div class="col-md-12"><div class="title text-center"><h2>Testimonials</h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt
                                ut labore et dolore magna aliqua.</p></div></div><div class="testimonials-slider"><div class="container"><div class="row justify-content-evenly"><div id="testimonials-carousel" class="swiper testimonials-carousel"><div class="swiper-wrapper"><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Missy Limana</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Ronne Waster</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Hanna Lisem</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Hanna Lisem</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div></div><div class="swiper-button-prev empty"></div><div class="swiper-button-next empty"></div><div class="swiper-pagination empty"></div></div></div></div></div></div></div></section>', 'styles' => '#ii9sjz{min-height:750px;}#ilbh26{max-width:1020px;margin-top:0px;margin-right:auto;margin-bottom:0px;margin-left:auto;padding-top:3rem;padding-right:2rem;padding-bottom:3rem;padding-left:2rem;}', 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => NULL, 'meta_description' => NULL, 'og_title' => NULL, 'og_description' => NULL),
            array('title' => 'SmallPDF', 'slug' => 'smallpdf', 'content' => '<section id="iz6f" class="section d-flex align-items-center section-xxxl"><div class="container"><div class="row justify-contant-center align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="content"><h2 id="ia8k" class="display-4 fw-bold">We Make
              <span id="idth" class="text-secondary">PDF</span> Simples
            </h2><p class="fs-xl">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
              incididunt
              ut labore et dolore magna aliqua.
            </p><button role="button" id="itlcy" null="btn-primary" class="btn px-4 me-2 mb-2 mb-md-0 btn-primary">Get Started Free</button><button role="button" class="btn btn-dark px-4">Explore All PDF Tools</button></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12 text-center text-lg-end mt-3 mt-lg-0"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" id="ihzuuy" class="img-fluid"/></div></div></div></section><section id="if22zg" class="section section-xxl"><div class="container"><div class="row"><div class="col-md-12"><h3 class="text-center h1">Most Popular PDF Tools</h3><p class="text-center">21 tools to convert, compress, and edit PDFs for free. Try it out today!</p><x-shortcode-tools layout="style1"></x-shortcode-tools></div></div></div></section><section id="ijj04u" class="section section-xxl"><div class="container"><div class="row"><div class="col-md-12"><h3 class="text-center h1">Keep Your Simple Tasks Simple</h3><p class="text-center">TruPDF stands out as the premier PDF software that you\'ll adore. Equipped with a comprehensive suite of tools, <br/>it empowers you to effortlessly initiate, oversee, and finalize your tasks involving digital documents.</p></div></div></div></section><section class="section section-xxxl"><div class="container"><div class="row"><div class="col-md-6 align-self-center"><h3>Interact directly with your files for efficient work.</h3><p class="fs-lg">Extend your capabilities beyond basic PDF viewing. With our platform, you can effortlessly highlight important sections, insert textual content, embed images, incorporate shapes, and freely annotate your documents by hand. Moreover, our integration with 20 additional tools allows you to enhance your files to new heights, ensuring a comprehensive and enriched document experience.</p></div><div class="col-md-6"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" id="i8urok" class="img-fluid"/></div></div></div></section><section class="section section-xxxl"><div class="container"><div class="row"><div class="col-md-6"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" id="ixjtl9" class="img-fluid"/></div><div class="col-md-6 align-self-center"><h3>Effortlessly manage all your documents from a single, convenient location.</h3><p class="fs-lg">Eliminate the hassle of toggling between various applications! Streamline your workflow and maximize efficiency by consolidating the storage, organization, and distribution of your documents across all your devices. Our intuitive web platform serves as a unified hub, allowing you to seamlessly store, manage, and share files with ease, regardless of your location or device. Say hello to a more streamlined and productive document management experience.</p></div></div></div></section><section id="i6scw9" class="section section-xxxl"><div class="container"><div class="row"><div class="col-md-6 align-self-center"><h3>Unlocking the Power of OCR PDF</h3><p class="fs-lg">Say goodbye to static documents and hello to dynamic content with OCR PDF technology. Optical Character Recognition (OCR) allows you to convert scanned documents and images into editable and searchable text, revolutionizing the way you interact with your PDFs. With OCR PDF, you can effortlessly extract text from your documents, enabling seamless editing, searching, and sharing. Experience the convenience and efficiency of OCR PDF as you unlock the full potential of your digital documents.</p><a id="i7wyp1" href="https://trupdf.com/ocr-pdf" class="btn btn-primary">OCR My PDF</a></div><div class="col-md-6"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" id="ib5obj" class="img-fluid"/></div></div></div></section><section id="imsxap" class="section brands-container section-xxl"><div class="container"><div class="row"><div class="col-md-12 text-center"><h2 class="section-heading">You’re in Good Company!</h2></div></div><div class="row row-cols-2 row-cols-md-3 row-cols-lg-5 justify-content-center featured-brands g-3"><div data-aos="fade-up" data-aos-delay="0" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="100" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="200" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="300" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="400" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div></div></div></section><section class="section section-lg"><div class="container"><div class="row"><div class="col-md-12"><h3 class="text-center h1">Plans &amp; Pricing</h3><p class="text-center">unlimited access to TruPDF\'s tools for yourself and your team, with pricing options tailored to your needs.</p><x-shortcode-plans></x-shortcode-plans></div></div></div></section><section class="section section-lg"><div class="container"><div class="row row-cols-1 row-cols-lg-3 row-cols-md-2"><div id="iforvj" class="col-12 col-sm-12 col-md-12 col-lg-12 col-xl-12"><h3 id="iigdc6" class="h1 text-center mb-5">Why Choose TruPDF?</h3></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-question-circle" id="i7d3d8"></i><h3 class="fw-normal h5">How to use?</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero
                                            vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                                            consectetur
                                            convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-cup" id="iq2yi3"></i><h3 class="fw-normal h5">Security and Privacy</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-world" id="i2zwld"></i><h3 class="fw-normal h5">Access from anywhere</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-checkmark-circle" id="ii1czq"></i><h3 class="fw-normal h5">Easy to use?</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero
                                            vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                                            consectetur
                                            convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-empty-file" id="iupcz4"></i><h3 class="fw-normal h5">Convert any Format</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-star-empty" id="io9idk"></i><h3 class="fw-normal h5">You\'re in Good Company</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div></div></div></section><section class="section section-xl try-pdf"><div class="container"><div data-aos-duration="" data-aos="" data-aos-anchor-placement="top-center" id="call-to-action" class="wrap mx-auto py-5"><div class="row align-items-center"><div class="col-12 col-lg-9 col-md-12 col-sm-12"><div class="row"><div class="col-md-9"><div class="title"><h1>Try PDF tools and see for yourself </h1><p>Try it for free Lorem, ipsum dolor sit amet consectetur adipisicing elit.
                                            Aliquam rem
                                            voluptatibus doloremque saepe, ex dolor quasi at fugiat quis pariatur
                                            dolorum nulla,
                                            autem, dicta architecto. </p></div></div></div></div><div class="col-12 col-lg-3 col-md-12 col-sm-12 d-grid"><a href="#" class="btn btn-light rounded-pill btn-lg px-4">Try for free</a></div></div></div></div></section><section class="section section-xxxl stress-less"><div class="container"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12 order-md-2 order-sm-2 order-lg-1"><div class="title mb-5"><h2>Stress less about your PDF Workflow</h2><p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Earum illo soluta modi inventore
                                dolores nihil excepturi blanditiis ipsam?s</p></div><div class="icon-area"><div class="item"><i class="lni lni-calendar"></i><div class="content"><h6>Try it for 30 days no credit card required</h6><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p></div></div><div class="item"><i class="lni lni-timer"></i><div class="content"><h6>Watch your document processing time plummet</h6><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p></div></div></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12 order-md-1 order-sm-1 order-lg-2"><img src="/themes/echo/images/stress-less-img.svg" alt="stress less img" class="img-fluid"/></div></div></div></section><section class="section section-lg border-top"><div id="i0bjj4" class="container-fluid"><div class="row"><div class="col-md-12"><x-shortcode-tools layout="style3" id="i5pg2q"></x-shortcode-tools></div></div></div></section>', 'styles' => '#i7d3d8{font-size:5rem;}#iq2yi3{font-size:5rem;}#i2zwld{font-size:5rem;}#ii1czq{font-size:5rem;}#iupcz4{font-size:5rem;}#io9idk{font-size:5rem;}#call-to-action{max-width:1020px;}', 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'SmallPDF', 'meta_description' => NULL, 'og_title' => 'SmallPDF', 'og_description' => NULL),
            array('title' => 'ILovePDF', 'slug' => 'ilovepdf', 'content' => '<section id="iug9" class="section"><div id="ixt3" class="container-fluid"><div class="row"><div class="col-md-12"><h1 id="i1yx" class="text-center display-5 fw-semibold">Access essential PDF tools conveniently in one place for effortless workflow.</h1><p class="text-center fs-xl">Access every essential PDF tool right at your fingertips—all completely free and user-friendly! Merge, split, compress, convert, rotate, unlock, <br/>and watermark PDFs effortlessly with just a few clicks.</p></div></div></div></section><section id="ihtvc" class="section section-lg pt-0"><div id="iymsf" class="container"><div class="row"><div class="col-md-12"><x-shortcode-tools layout="style2" id="ivhsk"></x-shortcode-tools></div></div></div></section><section class="section section-xxxl free-tools"><div class="container"><div class="row justify-content-center align-items-center"><div class="col-md-12 col-lg-6 col-sm-12"><div class="title"><h2>Free PDF tools</h2><div class="page-divider bg-primary"></div><p class="fs-lg lh-lg">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do
                                eiusmod
                                tempor incididunt
                                ut
                                labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation
                                ullamco
                                laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit
                                in
                                voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat
                                cupidatat
                                non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><a class="btn btn-primary px-5">Signup</a></div></div><div class="col-md-12 col-lg-6 col-sm-12 tools"><div class="row"><div class="col-md-6 col-sm-12"><div class="card active"><div class="card-body"><i class="lni lni-happy"></i><h6>Easy to use</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div><div class="card"><div class="card-body"><i class="lni lni-infinite"></i><h6>No limits</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div><div class="col-md-6 col-sm-12 card-down"><div class="card"><div class="card-body"><i class="lni lni-star-fill"></i><h6>Easy to use</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div><div class="card"><div class="card-body"><i class="lni lni-invention"></i><h6>No limits</h6><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div></div></div></div></section><section id="ib4v7" class="section brands-container section-xxxl"><div class="container"><div class="row"><div class="col-md-12 text-center"><h3 class="h1">The go-to PDF software trusted by millions of users worldwide.</h3><p class="fs-lg">stands as your top web application for effortless PDF editing. Benefit
from a comprehensive suite of tools designed to enhance your efficiency
with digital documents, <br id="ie90c-2" draggable="true"/>all while ensuring the safety and security of
your data.</p></div></div><div class="row row-cols-2 row-cols-md-3 row-cols-lg-5 justify-content-center featured-brands g-3"><div data-aos="fade-up" data-aos-delay="0" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="100" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="200" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="300" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div><div data-aos="fade-up" data-aos-delay="400" data-aos-duration="500" data-aos-anchor-placement="top-bottom" data-aos-once="false" class="col"><div class="card brand-image"><div class="card-body text-center"><img src="https://dummyimage.com/320x16:6/f8f8f8/222?text=Image" alt="company logo" class="img-fluid"/></div></div></div></div></div></section><section id="i9ys5i" class="section section-xxxl text-white"><div id="ikveik" class="container-fluid"><div class="row"><div class="col-md-9 align-self-center"><h2 id="ipht1b" class="text-white">Unlock premium features for an enhanced experience.</h2><p>Accelerate project completion with batch file processing, effortlessly convert scanned documents with OCR technology, and securely e-sign your business agreements.</p><a class="btn btn-warning btn-lg">Go Premium</a></div><div class="col-md-3"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" class="img-fluid"/></div></div></div></section>', 'styles' => '#i9ys5i{background-repeat:repeat;background-position:left top;background-attachment:scroll;background-size:auto;background-image:linear-gradient(#47474f 0%, #47474f 100%);}', 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'ILovePDF', 'meta_description' => NULL, 'og_title' => 'ILovePDF', 'og_description' => NULL),
            array('title' => 'Homepage Three', 'slug' => 'homepage-three', 'content' => '<section id="ifik" class="section d-flex align-items-center banner section-xxxl"><div class="container"><div id="ife5" class="row justify-contant-center align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="content"><h1 id="iwuf" class="display-4 fw-semibold">
                                    Tools to Make <br/><span class="text-secondary">Everything</span> Simples
                                </h1><p id="imgwi" class="mb-3">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor
                                    incididunt
                                    ut labore et dolore magna aliqua. </p><button role="button" id="i1lsj" class="btn btn-secondary rounded-pill btn-lg px-4 me-2 mb-2 mb-md-0 text-white">Get Started Free</button></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12 text-center text-lg-end mt-3 mt-lg-0"><svg width="450" height="282" viewBox="0 0 664 416" fill="none" xmlns="http://www.w3.org/2000/svg" id="i5h5n"><mask id="mask0_39_153" maskUnits="userSpaceOnUse" x="0" y="0" width="664" height="416"><rect width="664" height="416" fill="#D9D9D9"></rect></mask><g mask="url(#mask0_39_153)"><path d="M610.5 324.5C610.5 476.377 487.155 599.5 335 599.5C182.845 599.5 59.5 476.377 59.5 324.5C59.5 172.623 182.845 49.5 335 49.5C487.155 49.5 610.5 172.623 610.5 324.5Z" stroke="#D3E0F0"></path><path d="M515.5 324.5C515.5 424.465 434.686 505.5 335 505.5C235.314 505.5 154.5 424.465 154.5 324.5C154.5 224.535 235.314 143.5 335 143.5C434.686 143.5 515.5 224.535 515.5 324.5Z" stroke="#D3E0F0"></path><path d="M504.8 411.333H165.924V414.663H504.8V411.333Z" fill="url(#paint0_linear_39_153)"></path><path d="M499.927 419H170.874C168.167 419 165.924 416.832 165.924 414.043H504.8C504.8 416.754 502.634 419 499.927 419Z" fill="url(#paint1_linear_39_153)"></path><path d="M469.219 409.628H201.583V240.945C201.583 236.995 204.754 233.82 208.699 233.82H462.102C466.047 233.82 469.219 236.995 469.219 240.945V409.628Z" fill="black"></path><path d="M467.594 409.629H203.903V239.551C203.903 237.305 205.682 235.524 207.926 235.524H463.572C465.815 235.524 467.594 237.305 467.594 239.551V409.629Z" fill="#212120"></path><g clip-path="url(#clip0_39_153)"><path d="M425.894 411.023C418.669 411.023 241.651 411.023 241.651 411.023C241.651 411.023 241.651 405.117 241.651 397.899V210.388C241.651 203.17 247.562 197.264 254.788 197.264H377.945L425.894 245.167V397.899C425.894 405.281 425.894 411.023 425.894 411.023Z" fill="#D3E0F0"></path><path d="M425.894 245.167H391.082C383.856 245.167 377.945 239.261 377.945 232.043V197.264L425.894 245.167Z" fill="#88BCD6"></path><path d="M323.92 261.408H367.928V267.971H323.92V261.408ZM263.163 285.196H299.124V291.922H263.163V285.196ZM263.163 356.558H301.588V363.284H263.163V356.558ZM307.171 387.072H263.163V380.346H307.171V387.072ZM307.171 339.169H263.163V332.443H307.171V339.169ZM307.171 315.545H263.163V308.819H307.171V315.545ZM307.171 268.135H263.163V261.573H307.171V268.135ZM307.171 244.347H263.163V237.621H307.171V244.347ZM312.918 285.196H348.88V291.922H312.918V285.196ZM359.389 308.819V315.545H323.92V308.819H359.389ZM354.792 363.12H316.367V356.394H354.792V363.12ZM367.928 339.169H323.92V332.443H367.928V339.169ZM400.278 291.758H364.316V285.032H400.278V291.758Z" fill="white"></path><path d="M447.406 370.338H348.552C342.312 370.338 337.385 365.417 337.385 359.183V328.341C337.385 322.107 342.312 317.186 348.552 317.186H447.406V370.338Z" fill="#0405F5"></path><path d="M291.899 233.683L280.569 222.856C279.912 222.2 278.927 222.2 278.27 222.856L266.939 233.683C266.118 234.504 264.805 233.848 264.805 232.699V197.264H294.198V232.863C294.198 234.012 292.72 234.504 291.899 233.683Z" fill="#0405F5"></path><g clip-path="url(#clip1_39_153)"><path d="M380.91 337.576C380.49 336.804 379.649 336.225 378.599 335.646C377.548 335.26 376.497 335.067 375.026 335.067H368.092V351.472H371.875V345.682H375.026C377.128 345.682 378.809 345.103 380.069 344.331C381.33 343.366 381.961 342.208 381.961 340.471C381.75 339.506 381.54 338.541 380.91 337.576ZM377.338 342.401C376.918 342.787 376.077 342.98 375.026 342.98H371.875V337.769H375.237C376.077 337.769 376.918 337.962 377.338 338.541C377.758 339.12 378.178 339.699 378.178 340.471C378.178 341.243 377.758 342.015 377.338 342.401ZM397.09 338.734C396.459 337.576 395.409 336.611 394.148 336.032C392.887 335.453 391.416 335.067 389.945 335.067H384.272V351.472H389.735C391.416 351.472 392.677 351.086 393.938 350.507C395.199 349.928 396.249 348.963 396.88 347.805C397.51 346.647 397.93 345.296 397.93 343.752V342.98C398.14 341.436 397.72 340.085 397.09 338.734ZM394.358 343.752C394.358 345.296 393.938 346.647 393.097 347.419C392.257 348.384 391.206 348.77 389.735 348.77H388.054V337.769H389.945C391.416 337.769 392.467 338.155 393.307 339.12C394.148 339.892 394.358 341.243 394.358 342.98V343.752ZM412.429 337.769V335.067H400.872V351.472H404.654V344.717H411.798V342.015H404.654V337.769H412.429Z" fill="white"></path></g></g><g clip-path="url(#clip2_39_153)"><path d="M617.469 414.429L553.024 377.221C550.077 375.52 549.057 371.716 550.759 368.768L594.967 292.198C596.669 289.251 600.473 288.231 603.42 289.933L653.663 318.941L661.931 349.796L625.922 412.164C624.182 415.178 620.417 416.13 617.469 414.429Z" fill="#E0E9FA"></path><path d="M661.931 349.796L647.729 341.596C644.781 339.894 643.762 336.09 645.464 333.143L653.663 318.941L661.931 349.796Z" fill="#88BCD6"></path><path d="M616.501 332.409L634.454 342.775L632.907 345.454L614.953 335.089L616.501 332.409ZM586.106 327.812L600.777 336.283L599.191 339.029L584.52 330.559L586.106 327.812ZM569.282 356.953L584.957 366.004L583.372 368.75L567.696 359.7L569.282 356.953ZM580.041 379.779L562.088 369.413L563.673 366.667L581.627 377.032L580.041 379.779ZM591.335 360.218L573.381 349.852L574.967 347.106L592.92 357.471L591.335 360.218ZM596.904 350.571L578.951 340.206L580.536 337.459L598.49 347.824L596.904 350.571ZM608.082 331.211L590.128 320.845L591.675 318.166L609.629 328.531L608.082 331.211ZM613.69 321.497L595.737 311.132L597.322 308.385L615.276 318.751L613.69 321.497ZM606.404 339.532L621.075 348.002L619.489 350.748L604.818 342.278L606.404 339.532ZM619.793 360.124L618.207 362.87L603.737 354.516L605.323 351.77L619.793 360.124ZM605.115 381.215L589.439 372.164L591.025 369.418L606.701 378.468L605.115 381.215ZM616.121 374.528L598.168 364.163L599.753 361.416L617.707 371.782L616.121 374.528ZM640.496 362.787L625.825 354.317L627.411 351.57L642.082 360.041L640.496 362.787Z" fill="white"></path><path d="M641.196 405.976L600.868 382.692C598.322 381.223 597.473 378.053 598.942 375.507L606.214 362.913C607.683 360.367 610.853 359.518 613.399 360.987L653.727 384.271L641.196 405.976Z" fill="#9567E3"></path><path d="M609.974 313.546L607.904 306.456C607.791 306.033 607.389 305.801 606.966 305.914L599.791 307.667C599.263 307.809 598.882 307.231 599.153 306.762L607.507 292.292L619.498 299.216L611.105 313.753C610.834 314.221 610.116 314.074 609.974 313.546Z" fill="#9567E3"></path><g clip-path="url(#clip3_39_153)"><path d="M615.389 370.436L614.04 377.972L619.805 372.986L622.144 374.336L617.144 382.997L615.325 381.947L616.675 379.608L619.198 375.638L613.16 380.697L611.947 379.997L613.309 372.238L611.132 376.408L609.782 378.747L608.05 377.747L613.05 369.086L615.389 370.436Z" fill="white"></path><path d="M628.117 383.79C627.617 384.656 627.044 385.249 626.384 385.792C625.724 386.334 625.041 386.517 624.235 386.514C623.429 386.51 622.722 386.333 622.029 385.933C621.337 385.533 620.744 384.96 620.424 384.314C620.105 383.667 619.972 382.898 619.975 382.092C619.979 381.285 620.292 380.543 620.792 379.677L621.042 379.244C621.542 378.377 622.115 377.785 622.775 377.242C623.435 376.699 624.118 376.516 624.924 376.52C625.73 376.523 626.437 376.7 627.129 377.1C627.822 377.5 628.415 378.073 628.735 378.72C629.054 379.366 629.187 380.136 629.184 380.942C629.18 381.748 628.817 382.577 628.317 383.444L628.117 383.79ZM626.585 382.444C627.085 381.577 627.312 380.785 627.265 380.065C627.219 379.345 626.886 378.922 626.279 378.572C625.673 378.222 625.09 378.232 624.494 378.465C623.897 378.698 623.324 379.291 622.774 380.244L622.524 380.677C622.024 381.543 621.797 382.335 621.844 383.055C621.89 383.775 622.223 384.198 622.829 384.548C623.436 384.898 624.019 384.888 624.615 384.655C625.212 384.422 625.785 383.829 626.335 382.877L626.585 382.444Z" fill="white"></path><path d="M627.016 388.697L632.016 380.037L635.047 381.787C636.086 382.387 636.766 383.01 637.035 383.743C637.305 384.476 637.265 385.145 636.815 385.925C636.565 386.358 636.278 386.654 635.818 386.851C635.359 387.047 634.999 387.07 634.552 387.044C634.935 387.38 635.132 387.84 635.192 388.336C635.251 388.833 635.088 389.316 634.838 389.749C634.338 390.615 633.728 391.071 632.959 391.204C632.189 391.337 631.31 391.06 630.307 390.597L627.016 388.697ZM631.735 384.724L633.034 385.474C633.9 385.974 634.619 385.928 635.019 385.235C635.269 384.802 635.333 384.492 635.173 384.169C635.013 383.845 634.717 383.559 634.197 383.259L632.985 382.559L631.735 384.724ZM630.985 386.023L629.635 388.361L631.194 389.261C631.627 389.511 632.023 389.625 632.296 389.551C632.569 389.478 632.893 389.318 633.143 388.885C633.593 388.106 633.41 387.423 632.63 386.973L630.985 386.023Z" fill="white"></path><path d="M636.629 394.247L634.897 393.247L639.897 384.586L641.629 385.586L636.629 394.247Z" fill="white"></path></g></g><g clip-path="url(#clip4_39_153)"><path d="M505.076 143.92L440.632 106.713C437.684 105.011 436.665 101.207 438.367 98.2593L482.574 21.6893C484.276 18.7417 488.08 17.7224 491.028 19.4242L541.27 48.4319L549.538 79.2868L513.53 141.655C511.789 144.669 508.024 145.622 505.076 143.92Z" fill="#E0E9FA"></path><path d="M549.538 79.287L535.336 71.0875C532.389 69.3857 531.369 65.5817 533.071 62.6341L541.271 48.4321L549.538 79.287Z" fill="#88BCD6"></path><path d="M504.108 61.9005L522.061 72.2659L520.514 74.9455L502.561 64.5801L504.108 61.9005ZM473.713 57.3037L488.384 65.7739L486.799 68.5205L472.128 60.0503L473.713 57.3037ZM456.889 86.4445L472.565 95.4949L470.979 98.2415L455.303 89.1911L456.889 86.4445ZM467.648 109.27L449.695 98.9047L451.281 96.1581L469.234 106.523L467.648 109.27ZM478.942 89.7089L460.989 79.3435L462.574 76.5969L480.528 86.9623L478.942 89.7089ZM484.512 80.0623L466.558 69.6969L468.144 66.9503L486.097 77.3157L484.512 80.0623ZM495.689 60.7021L477.736 50.3367L479.283 47.6571L497.236 58.0225L495.689 60.7021ZM501.297 50.9885L483.344 40.6231L484.93 37.8765L502.883 48.2419L501.297 50.9885ZM494.011 69.0228L508.682 77.493L507.097 80.2396L492.426 71.7694L494.011 69.0228ZM507.4 89.615L505.815 92.3616L491.345 84.0073L492.93 81.2607L507.4 89.615ZM492.722 110.706L477.047 101.655L478.632 98.9088L494.308 107.959L492.722 110.706ZM503.729 104.019L485.775 93.654L487.361 90.9074L505.314 101.273L503.729 104.019ZM528.103 92.2785L513.432 83.8083L515.018 81.0617L529.689 89.5319L528.103 92.2785Z" fill="white"></path><path d="M528.803 135.467L488.475 112.184C485.93 110.714 485.08 107.544 486.55 104.998L493.821 92.404C495.291 89.8583 498.461 89.0089 501.007 90.4787L541.335 113.762L528.803 135.467Z" fill="#21ACFB"></path><path d="M497.581 43.0372L495.512 35.9472C495.398 35.5245 494.997 35.2924 494.574 35.4057L487.399 37.1584C486.871 37.2999 486.489 36.7225 486.76 36.2536L495.114 21.7837L507.106 28.7069L498.713 43.2438C498.442 43.7127 497.723 43.5656 497.581 43.0372Z" fill="#21ACFB"></path><g clip-path="url(#clip5_39_153)"><path d="M505.396 108.023L502.019 106.073L500.669 108.411L504.653 110.711L503.853 112.097L498.05 108.747L503.05 100.086L508.853 103.436L508.003 104.909L504.019 102.609L502.819 104.687L506.196 106.637L505.396 108.023Z" fill="white"></path><path d="M508.2 110.566L506.45 113.597L504.718 112.597L509.718 103.937L513.096 105.887C513.702 106.237 514.258 106.673 514.628 107.233C514.997 107.793 515.144 108.339 515.154 108.922C515.163 109.505 515.037 110.125 514.737 110.644C514.237 111.51 513.627 111.967 512.721 112.136C511.814 112.306 510.935 112.029 509.896 111.429L508.25 110.479L508.2 110.566ZM509.05 109.093L510.609 109.993C511.042 110.243 511.525 110.407 511.848 110.247C512.172 110.087 512.495 109.927 512.745 109.494C512.995 109.061 513.108 108.665 512.998 108.255C512.889 107.845 512.642 107.472 512.209 107.222L510.65 106.322L509.05 109.093Z" fill="white"></path><path d="M518.402 117.495C518.602 117.149 518.666 116.839 518.506 116.516C518.346 116.193 518.013 115.77 517.557 115.16C517.101 114.55 516.681 114.077 516.435 113.704C515.782 112.634 515.663 111.641 516.213 110.688C516.463 110.255 516.886 109.922 517.346 109.726C517.805 109.53 518.352 109.383 518.971 109.51C519.591 109.637 520.161 109.85 520.767 110.2C521.373 110.55 521.843 110.937 522.212 111.497C522.582 112.056 522.778 112.516 522.788 113.099C522.798 113.682 522.721 114.215 522.421 114.735L520.602 113.685C520.852 113.252 520.916 112.942 520.806 112.532C520.696 112.122 520.4 111.836 519.88 111.536C519.447 111.286 519.051 111.172 518.691 111.196C518.331 111.219 518.095 111.429 517.945 111.688C517.795 111.948 517.818 112.308 517.978 112.631C518.137 112.954 518.47 113.378 518.89 113.851C519.729 114.797 520.222 115.544 520.405 116.227C520.588 116.91 520.498 117.666 520.148 118.272C519.698 119.052 519.138 119.421 518.282 119.504C517.426 119.587 516.633 119.36 515.68 118.81C514.987 118.41 514.431 117.974 514.062 117.414C513.692 116.854 513.446 116.481 513.386 115.985C513.326 115.488 513.503 114.782 513.803 114.262L515.621 115.312C515.071 116.265 515.428 117.048 516.553 117.698C516.986 117.948 517.383 118.061 517.656 117.988C517.929 117.915 518.252 117.755 518.402 117.495Z" fill="white"></path></g></g><g clip-path="url(#clip6_39_153)"><path d="M583.09 273.931L518.645 236.723C515.697 235.022 514.678 231.218 516.38 228.27L560.587 151.7C562.289 148.752 566.093 147.733 569.041 149.435L619.284 178.443L627.551 209.297L591.543 271.666C589.803 274.68 586.037 275.632 583.09 273.931Z" fill="#E0E9FA"></path><path d="M627.551 209.298L613.349 201.098C610.402 199.396 609.382 195.592 611.084 192.645L619.284 178.443L627.551 209.298Z" fill="#88BCD6"></path><path d="M582.121 191.911L600.075 202.277L598.528 204.956L580.574 194.591L582.121 191.911ZM551.727 187.314L566.397 195.785L564.812 198.531L550.141 190.061L551.727 187.314ZM534.902 216.455L550.578 225.506L548.992 228.252L533.316 219.202L534.902 216.455ZM545.662 239.281L527.708 228.915L529.294 226.169L547.247 236.534L545.662 239.281ZM556.955 219.72L539.002 209.354L540.588 206.608L558.541 216.973L556.955 219.72ZM562.525 210.073L544.571 199.708L546.157 196.961L564.111 207.326L562.525 210.073ZM573.702 190.713L555.749 180.347L557.296 177.668L575.249 188.033L573.702 190.713ZM579.311 180.999L561.357 170.634L562.943 167.887L580.896 178.253L579.311 180.999ZM572.025 199.034L586.696 207.504L585.11 210.25L570.439 201.78L572.025 199.034ZM585.413 219.626L583.828 222.372L569.358 214.018L570.944 211.271L585.413 219.626ZM570.736 240.717L555.06 231.666L556.646 228.92L572.321 237.97L570.736 240.717ZM581.742 234.03L563.788 223.665L565.374 220.918L583.327 231.284L581.742 234.03ZM606.116 222.289L591.446 213.819L593.031 211.072L607.702 219.543L606.116 222.289Z" fill="white"></path><path d="M606.817 265.478L566.488 242.194C563.943 240.725 563.093 237.555 564.563 235.009L571.834 222.415C573.304 219.869 576.474 219.02 579.02 220.489L619.348 243.773L606.817 265.478Z" fill="#A3BA43"></path><path d="M575.595 173.048L573.525 165.958C573.412 165.535 573.01 165.303 572.587 165.416L565.412 167.169C564.884 167.311 564.502 166.733 564.773 166.264L573.127 151.794L585.119 158.718L576.726 173.255C576.455 173.723 575.736 173.576 575.595 173.048Z" fill="#A3BA43"></path><g clip-path="url(#clip7_39_153)"><path d="M578.056 239.724L573.052 236.835L577.523 229.09L582.528 231.979L581.8 233.24L578.288 231.213L577.248 233.014L580.233 234.737L579.453 236.088L576.556 234.415L575.36 236.486L578.872 238.514L578.144 239.775L578.056 239.724ZM583.061 242.613L583.216 239.101L580.251 240.991L578.495 239.977L582.926 237.372L582.967 232.233L584.722 233.247L584.619 236.669L587.532 234.869L589.288 235.882L584.909 238.397L584.868 243.537L583.113 242.523L583.061 242.613ZM588.315 243.245C588.37 243.757 588.617 244.14 589.144 244.444C589.583 244.698 590.074 244.861 590.405 244.692C590.825 244.574 591.069 244.355 591.468 243.865L593.049 244.778C592.493 245.537 591.866 246.016 591.027 246.252C590.24 246.398 589.382 246.263 588.504 245.756C587.538 245.198 586.956 244.382 586.793 243.447C586.63 242.513 586.887 241.46 587.563 240.29L587.823 239.839C588.239 239.119 588.69 238.539 589.318 238.061C589.893 237.673 590.504 237.425 591.099 237.408C591.694 237.392 592.325 237.516 592.939 237.871C593.817 238.377 594.364 239.053 594.631 239.807C594.897 240.562 594.745 241.434 594.365 242.296L592.784 241.383C593.096 240.843 593.129 240.381 592.969 240.049C592.862 239.627 592.563 239.334 592.124 239.081C591.597 238.776 591.142 238.754 590.67 238.962C590.199 239.17 589.747 239.75 589.192 240.51L588.88 241.05C588.535 242.052 588.259 242.733 588.315 243.245ZM597.459 250.926L592.455 248.037L596.926 240.292L601.93 243.181L601.202 244.442L597.778 242.465L596.739 244.266L599.724 245.99L598.944 247.341L595.959 245.617L594.763 247.688L598.275 249.716L597.547 250.977L597.459 250.926ZM603.166 254.221L598.337 251.433L602.808 243.688L604.389 244.601L600.697 250.995L603.946 252.87L603.166 254.221Z" fill="white"></path></g></g><g clip-path="url(#clip8_39_153)"><path d="M215.345 107.052L150.9 144.259C147.953 145.961 144.149 144.942 142.447 141.994L98.2392 65.4242C96.5374 62.4766 97.5567 58.6726 100.504 56.9708L150.747 27.9631L181.602 36.2306L217.61 98.5987C219.351 101.613 218.293 105.35 215.345 107.052Z" fill="#E0E9FA"></path><path d="M181.602 36.2304L167.4 44.4299C164.452 46.1317 160.648 45.1124 158.947 42.1648L150.747 27.9629L181.602 36.2304Z" fill="#88BCD6"></path><path d="M143.83 66.8812L161.784 56.5158L163.331 59.1954L145.377 69.5608L143.83 66.8812ZM124.652 90.9052L139.323 82.435L140.908 85.1816L126.238 93.6518L124.652 90.9052ZM141.476 120.046L157.152 110.996L158.738 113.742L143.062 122.793L141.476 120.046ZM166.624 122.141L148.67 132.506L147.084 129.76L165.038 119.394L166.624 122.141ZM155.33 102.58L137.377 112.945L135.791 110.198L153.744 99.833L155.33 102.58ZM149.76 92.933L131.807 103.298L130.221 100.552L148.175 90.1864L149.76 92.933ZM138.583 73.5728L120.629 83.9382L119.082 81.2586L137.036 70.8932L138.583 73.5728ZM132.975 63.8592L115.021 74.2246L113.436 71.478L131.389 61.1126L132.975 63.8592ZM144.95 79.1861L159.621 70.7159L161.207 73.4625L146.536 81.9327L144.95 79.1861ZM169.478 77.8872L171.063 80.6338L156.594 88.988L155.008 86.2414L169.478 77.8872ZM180.404 101.144L164.728 110.194L163.143 107.448L178.818 98.3973L180.404 101.144ZM180.116 88.2692L162.163 98.6346L160.577 95.888L178.531 85.5226L180.116 88.2692ZM182.136 61.2896L167.465 69.7599L165.879 67.0133L180.55 58.543L182.136 61.2896Z" fill="white"></path><path d="M219.888 82.2777L179.56 105.561C177.014 107.031 173.844 106.181 172.374 103.636L165.103 91.0417C163.633 88.496 164.483 85.326 167.028 83.8563L207.357 60.5728L219.888 82.2777Z" fill="#36D5A8"></path><path d="M124.231 63.1015L117.055 61.3488C116.633 61.2356 116.231 61.4677 116.118 61.8903L114.048 68.9804C113.906 69.5087 113.216 69.5502 112.945 69.0812L104.591 54.6113L116.582 47.6882L124.975 62.2251C125.246 62.694 124.759 63.2431 124.231 63.1015Z" fill="#36D5A8"></path><g clip-path="url(#clip9_39_153)"><path d="M176.775 87.8969L181.125 91.5654L180.058 86.0015L181.796 84.998L185.513 91.4353L184.161 92.2157L183.157 90.4777L181.539 87.3779L182.552 93.1449L181.65 93.6652L177.162 89.9051L179.038 92.8563L180.041 94.5943L178.754 95.3376L175.037 88.9004L176.775 87.8969Z" fill="white"></path><path d="M188.936 85.7684L186.425 87.2178L187.429 88.9559L190.39 87.2463L190.985 88.2762L186.672 90.7663L182.955 84.3291L187.268 81.839L187.9 82.9334L184.939 84.643L185.831 86.1879L188.341 84.7384L188.936 85.7684Z" fill="white"></path><path d="M192.699 84.1104L191.669 84.7051L193.007 87.0225L191.655 87.8029L187.939 81.3657L190.321 79.9906C191.093 79.5446 191.784 79.4033 192.356 79.5021C192.928 79.601 193.483 79.9673 193.817 80.5467C194.078 80.9973 194.199 81.3563 194.192 81.7896C194.184 82.223 194.038 82.5648 193.764 82.9809L196.704 84.8025L196.741 84.8669L195.325 85.6845L192.699 84.1104ZM191.075 83.6751L192.169 83.0433C192.491 82.8575 192.711 82.6444 192.793 82.3398C192.874 82.0352 192.827 81.8049 192.642 81.4831C192.456 81.1612 192.28 81.0053 191.975 80.9236C191.671 80.842 191.376 80.9263 191.054 81.1121L190.024 81.7068L191.139 83.638L191.075 83.6751Z" fill="white"></path><path d="M202.024 80.7867C201.915 81.1929 201.742 81.6362 201.366 82.0251C200.989 82.414 200.613 82.8029 200.098 83.1002C199.519 83.4347 198.994 83.5661 198.394 83.5688C197.795 83.5715 197.352 83.3983 196.899 83.0592C196.445 82.7201 195.982 82.215 195.648 81.6357L195.387 81.1851C195.016 80.5414 194.81 79.8877 194.743 79.3256C194.676 78.7635 194.775 78.1914 195.012 77.7109C195.25 77.2305 195.663 76.9059 196.243 76.5714C197.015 76.1255 197.706 75.9841 198.343 76.0458C198.979 76.1075 199.571 76.5382 200.044 77.2091L198.757 77.9524C198.469 77.6033 198.192 77.4202 197.887 77.3386C197.583 77.2569 197.288 77.3412 196.902 77.5642C196.451 77.8244 196.241 78.2033 196.169 78.6738C196.097 79.1444 196.33 79.6965 196.638 80.3774L196.861 80.7636C197.232 81.4074 197.658 81.848 198.139 82.0856C198.619 82.3231 199.08 82.2289 199.531 81.9687C200.046 81.6714 200.293 81.3568 200.375 81.0522L199.78 80.0223L198.621 80.6913L198.064 79.7257L200.574 78.2762L202.024 80.7867Z" fill="white"></path><path d="M205.866 75.994L203.355 77.4434L204.358 79.1815L207.32 77.4719L207.914 78.5018L203.601 80.9919L199.885 74.5547L204.198 72.0646L204.83 73.1589L201.868 74.8685L202.76 76.4135L205.271 74.964L205.866 75.994Z" fill="white"></path></g></g><g clip-path="url(#clip10_39_153)"><path d="M370.666 101H296.193C292.787 101 290 98.2095 290 94.7989V6.20107C290 2.79048 292.787 0 296.193 0H354.254L376.859 22.6339V94.7989C376.859 98.287 374.072 101 370.666 101Z" fill="#D7E5FF"></path><path d="M376.859 22.6339H360.447C357.041 22.6339 354.254 19.8434 354.254 16.4328V0L376.859 22.6339Z" fill="#88BCD6"></path><path d="M328.784 30.3078H349.531V33.4083H328.784V30.3078ZM300.141 41.5473H317.095V44.7253H300.141V41.5473ZM300.141 75.2656H318.256V78.4436H300.141V75.2656ZM320.888 89.6831H300.141V86.505H320.888V89.6831ZM320.888 67.0492H300.141V63.8711H320.888V67.0492ZM320.888 55.8872H300.141V52.7092H320.888V55.8872ZM320.888 33.4859H300.141V30.3853H320.888V33.4859ZM320.888 22.2464H300.141V19.0684H320.888V22.2464ZM323.598 41.5473H340.551V44.7253H323.598V41.5473ZM345.506 52.7092V55.8872H328.784V52.7092H345.506ZM343.338 78.3661H325.223V75.1881H343.338V78.3661ZM349.531 67.0492H328.784V63.8711H349.531V67.0492ZM364.782 44.6478H347.828V41.4697H364.782V44.6478Z" fill="white"></path><path d="M387 81.7769H340.396C337.455 81.7769 335.132 79.4515 335.132 76.506V61.9335C335.132 58.988 337.455 56.6626 340.396 56.6626H387V81.7769Z" fill="#FF5F67"></path><path d="M313.689 17.208L308.347 12.0921C308.038 11.782 307.573 11.782 307.263 12.0921L301.922 17.208C301.535 17.5956 300.916 17.2855 300.916 16.7429V0H314.773V16.8204C314.773 17.363 314.076 17.5956 313.689 17.208Z" fill="#FF5F67"></path><g clip-path="url(#clip11_39_153)"><path d="M354.331 66.4291H352.009V72.8627H350.383V66.4291H348.061V65.1113H354.331V66.4291Z" fill="white"></path><path d="M359.905 69.4521H356.886V71.5449H360.447V72.8627H355.26V65.1113H360.447V66.4291H356.886V68.2119H359.905V69.4521Z" fill="white"></path><path d="M364.085 67.7468L365.556 65.1113H367.414L365.092 68.9095L367.414 72.7852H365.556L364.085 70.0722L362.614 72.8627H360.756L363.079 68.987L360.834 65.1113H362.692L364.085 67.7468Z" fill="white"></path><path d="M373.994 66.4291H371.672V72.8627H370.046V66.4291H367.724V65.1113H373.994V66.4291Z" fill="white"></path></g></g><g clip-path="url(#clip12_39_153)"><path d="M168.159 235.46L103.715 272.667C100.767 274.369 96.9631 273.349 95.2613 270.402L51.0536 193.832C49.3518 190.884 50.3711 187.08 53.3187 185.379L103.561 156.371L134.416 164.638L170.425 227.006C172.165 230.021 171.107 233.758 168.159 235.46Z" fill="#E0E9FA"></path><path d="M134.416 164.638L120.214 172.838C117.267 174.539 113.463 173.52 111.761 170.573L103.562 156.371L134.416 164.638Z" fill="#88BCD6"></path><path d="M96.6446 195.289L114.598 184.923L116.145 187.603L98.1917 197.969L96.6446 195.289ZM77.4663 219.313L92.1372 210.843L93.7229 213.589L79.0521 222.06L77.4663 219.313ZM94.2908 248.454L109.967 239.403L111.552 242.15L95.8765 251.2L94.2908 248.454ZM119.438 250.549L101.485 260.914L99.8989 258.167L117.852 247.802L119.438 250.549ZM108.144 230.987L90.191 241.353L88.6053 238.606L106.559 228.241L108.144 230.987ZM102.575 221.341L84.6215 231.706L83.0358 228.96L100.989 218.594L102.575 221.341ZM91.3973 201.981L73.4439 212.346L71.8968 209.666L89.8502 199.301L91.3973 201.981ZM85.7892 192.267L67.8358 202.632L66.25 199.886L84.2034 189.52L85.7892 192.267ZM97.7644 207.594L112.435 199.124L114.021 201.87L99.3501 210.34L97.7644 207.594ZM122.292 206.295L123.878 209.041L109.408 217.396L107.822 214.649L122.292 206.295ZM133.218 229.552L117.543 238.602L115.957 235.855L131.633 226.805L133.218 229.552ZM132.931 216.677L114.977 227.042L113.392 224.296L131.345 213.93L132.931 216.677ZM134.95 189.697L120.279 198.168L118.694 195.421L133.365 186.951L134.95 189.697Z" fill="white"></path><path d="M172.702 210.685L132.374 233.969C129.829 235.439 126.659 234.589 125.189 232.044L117.918 219.449C116.448 216.904 117.297 213.734 119.843 212.264L160.171 188.981L172.702 210.685Z" fill="#FE9C51"></path><path d="M77.045 191.509L69.8699 189.757C69.4473 189.643 69.0453 189.875 68.9321 190.298L66.8624 197.388C66.7209 197.916 66.0302 197.958 65.7595 197.489L57.4053 183.019L69.3965 176.096L77.7894 190.633C78.0602 191.102 77.5733 191.651 77.045 191.509Z" fill="#FE9C51"></path><g clip-path="url(#clip13_39_153)"><path d="M138.784 212.583L136.775 213.743L139.985 219.303L138.578 220.115L135.368 214.555L133.358 215.715L132.701 214.577L138.127 211.444L138.784 212.583Z" fill="white"></path><path d="M144.679 209.179L142.67 210.339L145.88 215.899L144.473 216.712L141.263 211.151L139.253 212.312L138.596 211.173L144.022 208.04L144.679 209.179Z" fill="white"></path><path d="M151.06 209.247L148.448 210.755L150.033 213.502L148.626 214.314L144.759 207.615L149.113 205.101L149.771 206.24L146.823 207.941L147.829 209.683L150.441 208.175L151.06 209.247Z" fill="white"></path></g></g><g clip-path="url(#clip14_39_153)"><path d="M120.2 375.756L55.7552 412.963C52.8077 414.665 49.0036 413.646 47.3019 410.698L3.09415 334.128C1.39237 331.181 2.41165 327.377 5.35923 325.675L55.602 296.667L86.4568 304.935L122.465 367.303C124.206 370.317 123.148 374.054 120.2 375.756Z" fill="#E0E9FA"></path><path d="M86.4569 304.935L72.2549 313.134C69.3074 314.836 65.5033 313.817 63.8016 310.869L55.6021 296.667L86.4569 304.935Z" fill="#D3E0F0"></path><path d="M48.6851 335.585L66.6385 325.22L68.1856 327.899L50.2322 338.265L48.6851 335.585ZM29.5068 359.609L44.1777 351.139L45.7635 353.886L31.0926 362.356L29.5068 359.609ZM46.3313 388.75L62.007 379.7L63.5928 382.446L47.917 391.497L46.3313 388.75ZM71.4786 390.845L53.5252 401.21L51.9394 398.464L69.8929 388.098L71.4786 390.845ZM60.185 371.284L42.2315 381.649L40.6458 378.903L58.5992 368.537L60.185 371.284ZM54.6155 361.637L36.6621 372.003L35.0763 369.256L53.0297 358.891L54.6155 361.637ZM43.4379 342.277L25.4844 352.642L23.9374 349.963L41.8908 339.597L43.4379 342.277ZM37.8297 332.563L19.8763 342.929L18.2905 340.182L36.2439 329.817L37.8297 332.563ZM49.8049 347.89L64.4758 339.42L66.0616 342.167L51.3907 350.637L49.8049 347.89ZM74.3327 346.591L75.9184 349.338L61.4485 357.692L59.8627 354.945L74.3327 346.591ZM85.259 369.848L69.5832 378.898L67.9975 376.152L83.6732 367.101L85.259 369.848ZM84.9714 356.973L67.018 367.339L65.4322 364.592L83.3856 354.227L84.9714 356.973ZM86.9909 329.994L72.32 338.464L70.7342 335.717L85.4051 327.247L86.9909 329.994Z" fill="white"></path><path d="M124.743 350.982L84.4148 374.265C81.8692 375.735 78.6991 374.886 77.2294 372.34L69.9582 359.746C68.4884 357.2 69.3378 354.03 71.8835 352.56L112.212 329.277L124.743 350.982Z" fill="#F0A3C3"></path><path d="M29.0855 331.806L21.9105 330.053C21.4878 329.94 21.0859 330.172 20.9726 330.594L18.9029 337.684C18.7614 338.213 18.0708 338.254 17.8 337.785L9.4458 323.315L21.4371 316.392L29.83 330.929C30.1007 331.398 29.6138 331.947 29.0855 331.806Z" fill="#F0A3C3"></path><g clip-path="url(#clip15_39_153)"><path d="M94.0737 358.506L92.6669 359.318L91.0038 356.438L88.3242 357.985L89.9873 360.865L88.6475 361.639L84.7798 354.94L86.1866 354.128L87.7337 356.807L90.4133 355.26L88.8662 352.581L90.273 351.768L94.1407 358.467L94.0737 358.506Z" fill="white"></path><path d="M97.6361 352.609L95.0235 354.117L96.0678 355.926L99.1493 354.147L99.7682 355.219L95.2798 357.81L91.4121 351.111L95.9005 348.519L96.558 349.658L93.4764 351.437L94.4047 353.045L97.0173 351.537L97.6361 352.609Z" fill="white"></path><path d="M101.979 353.942L100.572 354.755L96.7041 348.056L98.1109 347.243L101.979 353.942Z" fill="white"></path><path d="M107.267 347.942C107.626 348.717 107.667 349.408 107.43 350.08C107.193 350.753 106.639 351.341 105.903 351.766C105.032 352.269 104.207 352.388 103.39 352.056C102.573 351.724 101.88 351.141 101.299 350.137L101.067 349.735C100.681 349.065 100.505 348.451 100.435 347.866C100.366 347.281 100.469 346.686 100.716 346.186C100.963 345.686 101.422 345.243 101.958 344.933C102.694 344.508 103.48 344.322 104.181 344.453C104.882 344.584 105.498 345.033 105.991 345.731L104.584 346.543C104.285 346.18 104.025 345.884 103.708 345.799C103.391 345.714 103.017 345.84 102.615 346.072C102.146 346.343 101.889 346.67 101.881 347.121C101.873 347.572 102.049 348.185 102.436 348.855L102.745 349.391C103.17 350.128 103.614 350.587 104.008 350.806C104.403 351.025 104.815 350.965 105.284 350.694C105.686 350.462 105.982 350.202 106.067 349.885C106.152 349.568 106.131 349.223 105.899 348.821L107.306 348.009L107.267 347.942Z" fill="white"></path></g></g></g><defs><linearGradient id="paint0_linear_39_153" x1="165.96" y1="413.014" x2="504.824" y2="413.014" gradientUnits="userSpaceOnUse"><stop stop-color="#545353"></stop><stop offset="0.0184001" stop-color="#F2F0F2"></stop><stop offset="0.0379345" stop-color="#BDBCBE"></stop><stop offset="0.1983" stop-color="#C4C2C4"></stop><stop offset="0.9572" stop-color="#BFBDC0"></stop><stop offset="0.979" stop-color="#F2F0F2"></stop><stop offset="1" stop-color="#535352"></stop></linearGradient><linearGradient id="paint1_linear_39_153" x1="335.392" y1="418.994" x2="335.392" y2="414.067" gradientUnits="userSpaceOnUse"><stop stop-color="#545353"></stop><stop offset="0.1983" stop-color="#C4C2C4"></stop><stop offset="0.7492" stop-color="#BFBDC0"></stop><stop offset="0.979" stop-color="#F2F0F2"></stop><stop offset="1" stop-color="#535352"></stop></linearGradient><clipPath id="clip0_39_153"><rect width="205.755" height="213.759" fill="white" transform="translate(241.651 197.264)"></rect></clipPath><clipPath id="clip1_39_153"><rect width="44.3366" height="16.4051" fill="white" transform="translate(368.092 335.067)"></rect></clipPath><clipPath id="clip2_39_153"><rect width="96.9243" height="100.792" fill="white" transform="translate(598.061 286.839) rotate(30)"></rect></clipPath><clipPath id="clip3_39_153"><rect width="33" height="10.2" fill="white" transform="translate(613.1 369) rotate(30)"></rect></clipPath><clipPath id="clip4_39_153"><rect width="96.9243" height="100.792" fill="white" transform="translate(485.668 16.3301) rotate(30)"></rect></clipPath><clipPath id="clip5_39_153"><rect width="24.1" height="10.2" fill="white" transform="translate(503.1 100) rotate(30)"></rect></clipPath><clipPath id="clip6_39_153"><rect width="96.9243" height="100.792" fill="white" transform="translate(563.682 146.341) rotate(30)"></rect></clipPath><clipPath id="clip7_39_153"><rect width="34.7724" height="9.15063" fill="white" transform="translate(577.575 229) rotate(30)"></rect></clipPath><clipPath id="clip8_39_153"><rect width="96.9243" height="100.792" fill="white" transform="translate(95.145 60.0649) rotate(-30)"></rect></clipPath><clipPath id="clip9_39_153"><rect width="33.6717" height="7.58172" fill="white" transform="translate(175 88.8359) rotate(-30)"></rect></clipPath><clipPath id="clip10_39_153"><rect width="97" height="101" fill="white" transform="translate(290)"></rect></clipPath><clipPath id="clip11_39_153"><rect width="25.9338" height="7.75134" fill="white" transform="translate(348.061 65.1113)"></rect></clipPath><clipPath id="clip12_39_153"><rect width="96.9243" height="100.792" fill="white" transform="translate(47.9595 188.473) rotate(-30)"></rect></clipPath><clipPath id="clip13_39_153"><rect width="18.9517" height="7.73538" fill="white" transform="translate(132.701 214.577) rotate(-30)"></rect></clipPath><clipPath id="clip14_39_153"><rect width="96.9243" height="100.792" fill="white" transform="translate(0 328.769) rotate(-30)"></rect></clipPath><clipPath id="clip15_39_153"><rect width="22.9741" height="7.89009" fill="white" transform="translate(84.7412 354.873) rotate(-30)"></rect></clipPath></defs></svg></div></div><div id="iadooh" class="row mx-auto bg-white p-3"><div id="i7ev8e" class="col-4 text-center border-end"><i id="ip4xhl" class="lni lni-32 mb-3 text-primary lni-bullhorn"></i><p>Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.</p></div><div class="col-4 text-center border-end"><i id="iqqsv1" class="lni lni-32 mb-3 text-primary lni-bolt-alt"></i><p>Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.</p></div><div class="col-4 text-center"><i id="iyw624" class="lni lni-32 mb-3 text-primary lni-fireworks"></i><p>Vivamus sagittis lacus vel augue laoreet rutrum faucibus dolor auctor. Duis mollis, est non commodo luctus.</p></div></div></div><div class="section-divider-bottom"></div></section><section class="top-categories section section-xxxl"><div class="container"><div class="row"><div class="title text-center"><h2>Top Categories</h2><p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Reprehenderit, deserunt
                            molestias. Sapiente nesciunt accusamus minus, nemo iure natus.</p></div></div><div class="row"><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" alt="pdf to excel" id="idkumg" class="img-fluid"/></div><div class="content"><h4>PDF to Word</h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" alt="merge pdf" id="im97oy" class="img-fluid"/></div><div class="content"><h4>PDF to Word</h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" alt="pdf jpg" id="ihd9xx" class="img-fluid"/></div><div class="content"><h4>PDF to Word</h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div><div class="col-12 col-lg-3 col-md-6 col-sm-12"><div class="card"><div class="card-body"><div class="img-wrap justify-contant-center d-flex"><img src="https://dummyimage.com/800x500/f8f8f8/222?text=Upload+Image" alt="compress pdf" id="iprwkd" class="img-fluid"/></div><div class="content"><h4>PDF to Word</h4><p>Lorem ipsum dolor sit amet consectetur adipisicing elit.</p></div></div></div></div></div></div></section><section class="section section-lg"><div class="container"><div class="row"><div class="col"><h3 id="im1bkg" class="text-center h2 mb-5">Why Choose TruPDF?<br/></h3></div></div><div class="row row-cols-1 row-cols-lg-3 row-cols-md-2"><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-question-circle"></i><h3 class="fw-normal h5">How to use?</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero
                                            vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                                            consectetur
                                            convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-cup"></i><h3 class="fw-normal h5">Security and Privacy</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-world"></i><h3 class="fw-normal h5">Access from anywhere</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-checkmark-circle"></i><h3 class="fw-normal h5">Easy to use?</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero
                                            vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                                            consectetur
                                            convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-empty-file"></i><h3 class="fw-normal h5">Convert any Format</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-star-empty"></i><h3 class="fw-normal h5">You\'re in Good Company</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div></div></div></section><section class="section section-xxxl testimonials"><div class="container"><div class="row"><div class="col-md-12"><div class="title text-center"><h2>Testimonials</h2><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt
                                ut labore et dolore magna aliqua.</p></div></div><div class="testimonials-slider"><div class="container"><div class="row justify-content-evenly"><div id="testimonials-carousel" class="swiper testimonials-carousel"><div class="swiper-wrapper"><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Missy Limana</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Ronne Waster</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div><div class="swiper-slide testimonials-item"><div class="card"><div class="card-body"><div class="image"><img src="https://www.gravatar.com/avatar/00000000000000000000000000000000?d=mp&f=y&size=300" alt="Avatar" class="img-fluid"/></div><div class="content"><h4>Hanna Lisem</h4><h5>Project Manager</h5><p class="mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed
                                                            do eiusmod tempor incididunt ut
                                                            labore et dolore magna aliqua.</p></div></div></div></div></div><div class="swiper-button-prev empty"></div><div class="swiper-button-next empty"></div><div class="swiper-pagination empty"></div></div></div></div></div></div></div></section><section id="igcp02" class="section get-more mb-0 section-sm"><div class="container"><div class="get-more-wrap"><div class="content"><div class="row"><div class="col-12 col-lg-9"><div class="title"><h2>Get more with premium</h2><p>Complete project faster with batch file processing ,convert scanned document with
                                        OCR
                                        and e-design your business agrements.</p></div></div><div class="col-12 col-lg-3 align-self-center"><a href="#" type="button" class="btn btn-secondary px-5 rounded-pill">Try now</a></div></div></div><div class="facts-wrap"><div class="row"><div class="col-12 col-lg-4 col-md-4 col-sm-12"><div class="item"><i aria-hidden="true" class="lni lni-checkmark-circle"></i><p>Install the tools yourself, with support from our team.</p></div></div><div class="col-12 col-lg-4 col-md-4 col-sm-12"><div class="item"><i aria-hidden="true" class="lni lni-alarm-clock"></i><p>Watch your document processing with time plummet.</p></div></div><div class="col-12 col-lg-4 col-md-4 col-sm-12"><div class="item"><i aria-hidden="true" class="lni lni-credit-cards"></i><p>Try it for 30 days no credit card required.</p></div></div></div></div></div></div></section><section class="section section-xxl tools-detail"><div class="container"><div class="tools-detail-wrap nav-active-bg bg-warning-subtle"><div class="row"><div class="col-md-12"><ul class="nav nav-pills justify-content-lg-center flex-nav"><li class="nav-item"><a data-bg="bg-warning-subtle" data-bs-toggle="tab" href="#featuredTab1" class="nav-link rounded-pill px-5 me-2 active">Merge PDF</a></li><li class="nav-item"><a data-bg="bg-success-subtle" data-bs-toggle="tab" href="#featuredTab2" class="nav-link rounded-pill px-5 me-2">Compress PDF</a></li><li class="nav-item"><a data-bg="bg-danger-subtle" data-bs-toggle="tab" href="#featuredTab3" class="nav-link rounded-pill px-5 me-2">Unlock PDF</a></li><li class="nav-item"><a data-bg="bg-info-subtle" data-bs-toggle="tab" href="#featuredTab4" class="nav-link rounded-pill px-5">Remove PDF Pages</a></li></ul><div class="tab-content"><div id="featuredTab1" class="tab-pane container fade show active"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Merge PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab2" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Compress PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab3" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Unlock PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab4" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Remove PDF Pages</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div></div></div></div></div></div></section><section class="section section-lg"><div class="container"><div class="row"><div class="col"><h3 class="text-center h1">Recent Posts<br/></h3></div></div><div class="row"><div class="col-md-12"><x-shortcode-blog layout="card" order="latest" posts="3" columns="3" id="i36lz1"></x-shortcode-blog></div></div></div></section><section id="iunctj" class="section section-xl border-top"><div class="container"><div class="row"><div class="col-md-12"><x-shortcode-tools layout="style3" id="imoowk"></x-shortcode-tools></div></div></div></section>', 'styles' => '#ifik{background-repeat:no-repeat;background-position-x:center;background-position-y:center;background-attachment:scroll;background-size:cover;background-image:url(\'/themes/echo/images/header-bg-three.png\');--style-bottom:12;--fill-bottom:#ffffff;--zindex-bottom:1;--height-bottom:100px;--background-bottom:url(data:image/svg+xml;base64,PHN2ZyBmaWxsPSIjZmZmZmZmIiBoZWlnaHQ9IjEwMHB4IiB3aWR0aD0iMTAwJSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSIgdmlld0JveD0iMCAwIDEyODAgMTQwIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjxwYXRoIGQ9Ik0wIDEyNy44OTlsNjAuNjEzIDQuODc4IDk1LjY0NS02LjIxMSA4Ni4zNjMtMTYuMDc0IDc4LjY4NCA5Ljg4MyA5MC4xMzYtMjEuNTk0IDk0LjQ1NCA3LjU3NCA3Ny45MjUtMTcuNjYgOTEuNjY0IDIwLjc5OCA3Ni45NjEtMTIuNjQ5IDYzLjY2NC0yMS40MjIgOTcuNjAyIDcuMDcgODMuNjcyLTI5LjYxNyA2Ni4yODUgMTEuNjc4IDcwLjc5My0yMy4zMzQgNzQuODYzLTQuNjQxTDEyODAgMHYxNDBIMHoiIGZpbGwtb3BhY2l0eT0iLjUiLz48cGF0aCBkPSJNMCAxMjYuNzFsNjAuNjEzIDcuNDE1TDE1Ni4yNTcgMTMxbDg2LjM2NC0xMy44NzkgNzguNjgzIDkuNzMxIDkwLjEzNy0xNy4wNTkgOTQuNDUzIDcuNjY2IDc2LjkyNi0xMS44MzMgODIuNjY0IDEzLjkzNSA3Ni45NjEtOC40NzUgNzMuNjY0LTIyLjEyNiA5Ny42MDEgNy4zMjggODMuNjcyLTIyLjk1MiA2Ni4yODUgMTAuOTMzIDcwLjc5NC0xOC4yMjRoNzkuODYyTDEyODAgMzUuODM4VjE0MEgweiIvPjwvc3ZnPg==);--background-size-bottom:100% 100px;--transform-bottom:scale(1, 1);}#i5h5n{width:634px;height:397px;}#mask0_39_153{mask-type:alpha;}#iadooh{max-width:980px;border-radius:4px 4px 4px 4px;margin:4rem 0px 0px 0px;}#ip4xhl{font-size:4rem;}#iqqsv1{font-size:4rem;}#iyw624{font-size:4rem;}', 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Homepage Three', 'meta_description' => NULL, 'og_title' => 'Homepage Three', 'og_description' => NULL),
            array('title' => 'Homepage Four', 'slug' => 'homepage-four', 'content' => '<section id="i482" class="section d-flex align-items-center section-0"><div class="container"><div id="ix56" class="row justify-contant-center align-items-center"><div id="i4xb" class="col-12 col-md-12 col-sm-12 col-lg-12"><div id="i06g" class="content text-center"><h1 id="iw93" class="display-4 fw-bold mb-4">Discover our extensive range of <span class="text-secondary">PDF tools</span> tailored to
                            enhance your <span class="text-secondary">document management</span> experience.
                        </h1><p id="ikh0w" class="text-dark fs-xl mb-5">Explore the myriad possibilities inherent in PDF documents through our all-encompassing
                            toolkit,<br/>which presents an array
                            of robust tools meticulously designed to enhance and simplify your document management
                            processes.
                        </p><button role="button" id="iwmfd" class="btn btn-secondary btn-lg px-4 me-2 mb-2 mb-md-0 text-white">Get
                            Started Free</button><button role="button" class="btn btn-dark btn-lg px-4">Explore All PDF
                            Tools</button></div></div></div><div id="i6804" class="row mt-5"><div id="ipear" class="text-center col-12 col-sm-12"><img src="/themes/echo/images/header-hero-image.png" id="ium4q" class="img-fluid"/></div></div></div><div class="section-divider-bottom"></div></section><section class="section section-xxxl stress-less"><div class="container"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12 order-md-2 order-sm-2 order-lg-1"><div class="title mb-5"><h2>Stress less about your PDF Workflow</h2><p>Lorem ipsum dolor sit amet consectetur adipisicing elit. Earum illo soluta modi inventore
                                dolores nihil excepturi blanditiis ipsam?s</p></div><div class="icon-area"><div class="item"><i class="lni lni-calendar"></i><div class="content"><h6>Try it for 30 days no credit card required</h6><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p></div></div><div class="item"><i class="lni lni-timer"></i><div class="content"><h6>Watch your document processing time plummet</h6><p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p></div></div></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12 order-md-1 order-sm-1 order-lg-2"><img src="/themes/echo/images/stress-less-img.svg" alt="stress less img" class="img-fluid"/></div></div></div></section><section id="ig7zg" class="section section-xxxl"><div class="container"><div class="row"><div id="icx4sp" class="col col-sm-12"><h3 id="it3s1e" class="text-center h1 mb-5">Why Choose TruPDF?<br/></h3></div></div><div class="row row-cols-1 row-cols-lg-3 row-cols-md-2"><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-question-circle"></i><h3 class="fw-normal h5">How to use?</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero
                                            vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                                            consectetur
                                            convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-cup"></i><h3 class="fw-normal h5">Security and Privacy</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-world"></i><h3 class="fw-normal h5">Access from anywhere</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-checkmark-circle"></i><h3 class="fw-normal h5">Easy to use?</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero
                                            vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id arcu
                                            consectetur
                                            convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-empty-file"></i><h3 class="fw-normal h5">Convert any Format</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div><div class="col"><div class="card mb-4 mb-md-0"><div class="card-body text-center"><i class="lni lni-32 mb-3 text-primary lni-star-empty"></i><h3 class="fw-normal h5">You\'re in Good Company</h3><p class="mb-0">
                                            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Proin vehicula eros a nisi blandit, auctor
                                            luctus
                                            libero vestibulum. Sed in dolor sit amet nisl venenatis tincidunt vel eu nulla. Nullam et quam id
                                            arcu
                                            consectetur convallis.
                                        </p></div></div></div></div></div></section><section id="i9zns9" class="section tools-detail section-xxxl"><div class="container"><div class="tools-detail-wrap nav-active-bg bg-warning-subtle"><div class="row"><div class="col-md-12"><ul class="nav nav-pills justify-content-lg-center flex-nav"><li class="nav-item"><a data-bg="bg-warning-subtle" data-bs-toggle="tab" href="#featuredTab1" class="nav-link rounded-pill px-5 me-2 active">Merge PDF</a></li><li class="nav-item"><a data-bg="bg-success-subtle" data-bs-toggle="tab" href="#featuredTab2" class="nav-link rounded-pill px-5 me-2">Compress PDF</a></li><li class="nav-item"><a data-bg="bg-danger-subtle" data-bs-toggle="tab" href="#featuredTab3" class="nav-link rounded-pill px-5 me-2">Unlock PDF</a></li><li class="nav-item"><a data-bg="bg-info-subtle" data-bs-toggle="tab" href="#featuredTab4" class="nav-link rounded-pill px-5">Remove PDF Pages</a></li></ul><div class="tab-content"><div id="featuredTab1" class="tab-pane container fade show active"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Merge PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab2" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Compress PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab3" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Unlock PDF</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div><div id="featuredTab4" class="tab-pane container fade"><div class="row align-items-center"><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="title"><h2>Remove PDF Pages</h2><p class="lh-lg fs-lg">Lorem ipsum dolor sit amet consectetur adipisicing
                                                    elit. Est nulla aut
                                                    quod
                                                    labore accusamus similique, dolor quisquam consectetur sequi animi
                                                    voluptatem fuga
                                                    excepturi ut reprehenderit magni dolores ducimus temporibus libero
                                                    perspiciatis
                                                    asperiores nostrum laudantium odio distinctio beatae! Rem, illo
                                                    incidunt.</p><a href="#" class="btn btn-primary rounded-pill px-5">Visit
                                                    Tool</a></div></div><div class="col-12 col-lg-6 col-md-12 col-sm-12"><div class="img-wrap text-center text-lg-end mt-3 mt-lg-0"><img src="/themes/echo/images/split-pdf.svg" alt="img" class="img-fluid"/></div></div></div></div></div></div></div></div></div></section><section class="section section-xl try-pdf"><div id="igrch2" class="container-fluid g-0"><div data-aos-duration="" data-aos="" data-aos-anchor-placement="top-center" id="iyaypo" class="wrap rounded-0"><div class="row align-items-center"><div class="col-12 col-lg-9 col-md-12 col-sm-12"><div class="row"><div class="col-md-9"><div class="title"><h1>Try PDF tools and see for yourself </h1><p>Try it for free Lorem, ipsum dolor sit amet consectetur adipisicing elit.
                                            Aliquam rem
                                            voluptatibus doloremque saepe, ex dolor quasi at fugiat quis pariatur
                                            dolorum nulla,
                                            autem, dicta architecto. </p></div></div></div></div><div class="col-12 col-lg-3 col-md-12 col-sm-12 d-grid"><a href="#" class="btn btn-light rounded-pill btn-lg px-4">Try for free</a></div></div></div></div></section><section class="section section-lg"><div class="container"><div class="row"><div id="ifm7ds" class="col"><h3 class="text-center h1">Choose the Perfect Plan for Your Needs</h3><p class="text-center">Whether you\'re a startup, a growing enterprise, or an established corporation, we have the right plan for you.</p></div></div><div class="row"><div class="col-md-12"><x-shortcode-plans></x-shortcode-plans></div></div></div></section><section id="i2o10t" class="section bg-light section-xxxl"><div class="container" id="i2cwow"><div class="row"><div id="i0nbfl" class="col mb-3"><h3 class="text-center h1">Got Questions? We\'ve Got Answers!</h3></div></div><div class="row"><div class="col-md-12"><x-shortcode-faqs limit="5" exclude="" id="iqdjvg" layout="stack"></x-shortcode-faqs></div></div></div></section><section id="i2zobo" class="section border-top section-xl"><div id="i2rvzi" class="container-fluid"><div class="row"><div class="col-md-12"><x-shortcode-tools layout="style3" id="ike2mk"></x-shortcode-tools></div></div></div></section>', 'styles' => '#i482{background-repeat:no-repeat, no-repeat;background-attachment:scroll, scroll;background-size:cover, cover;background-image:url(\'/themes/echo/images/header-image-overlay.png\'), url("/themes/echo/images/header-bg-4.png");padding-top:8rem;padding-right:0px;padding-bottom:6rem;padding-left:0px;--style-bottom:18;--fill-bottom:#ffffff;--zindex-bottom:1;--height-bottom:250px;--background-bottom:url(data:image/svg+xml;base64,PHN2ZyBmaWxsPSIjZmZmZmZmIiBoZWlnaHQ9IjI1MHB4IiB3aWR0aD0iMTAwJSIgcHJlc2VydmVBc3BlY3RSYXRpbz0ibm9uZSIgdmlld0JveD0iMCAwIDEyODAgMTQwIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciPjxwYXRoIGQ9Ik0wIDE0MGgxMjgwQzU3My4wOCAxNDAgMCAwIDAgMHoiIGZpbGwtb3BhY2l0eT0iLjMiLz48cGF0aCBkPSJNMCAxNDBoMTI4MEM1NzMuMDggMTQwIDAgMzAgMCAzMHoiIGZpbGwtb3BhY2l0eT0iLjUiLz48cGF0aCBkPSJNMCAxNDBoMTI4MEM1NzMuMDggMTQwIDAgNjAgMCA2MHoiLz48L3N2Zz4=);--background-size-bottom:100% 250px;--transform-bottom:scale(-1, 1);background-position-x:left, center;background-position-y:top, top;background-position:center top;}#i2cwow{max-width:1020px;}', 'scripts' => NULL, 'excerpt' => NULL, 'meta_title' => 'Homepage Four', 'meta_description' => NULL, 'og_title' => 'Homepage Four', 'og_description' => NULL)
        );

        $pagesData = [];
        foreach ($pages as $index => $page) {
            dd($index);
        }

        return $pagesData;
    }
}
