<?php
    $favourites = Auth::check() ? Auth::user()->favorite_tools : null;
?>
<?php if($favourites && $favourites->count() > 0): ?>
    <li class="nav-item">
        <div id="favMenu" class="fav-menu">
            <div class="nav-link fav-btn ms-lg-2" data-bs-toggle="dropdown">
                <i class="an an-grid-layouts"></i>
                <span><?php echo app('translator')->get('tools.favoriteTools'); ?></span>
            </div>
            <div id="favrorite-tools" class="menu-items box-shadow p-0 dropdown-menu dropdown-menu-end">
                <div class="icons-container">
                    <?php $__currentLoopData = $favourites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e(route('tool.show', ['tool' => $tool->slug])); ?>" class="menu-link bg-hover"
                            data-bs-toggle="tooltip" title="<?php echo e($tool->name); ?>">
                            <?php if($tool->icon_type == 'class'): ?>
                                <i class="an-duotone an-<?php echo e($tool->icon_class); ?>"></i>
                            <?php elseif($tool->getFirstMediaUrl('tool-icon')): ?>
                                <img src="<?php echo e($tool->getFirstMediaUrl('tool-icon')); ?>" alt="<?php echo e($tool->name); ?>">
                            <?php endif; ?>
                            <span><?php echo e($tool->name); ?></span>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </li>
<?php endif; ?>
<?php /**PATH /home/newuserdapi/toolsfi.co/resources/themes/canvas/components/favorite-navbar.blade.php ENDPATH**/ ?>