<ul class="nav">
    <li class="nav-item"><a href="#themeGeneral" class="nav-link active" data-coreui-toggle="tab"><?php echo app('translator')->get('settings.general'); ?></a></li>
    <li class="nav-item"><a href="#lightTheme" class="nav-link" data-coreui-toggle="tab"><?php echo app('translator')->get('settings.fontColors'); ?></a></li>
    <li class="nav-item"><a href="#darkTheme" class="nav-link" data-coreui-toggle="tab"><?php echo app('translator')->get('settings.fontColorsDark'); ?></a></li>
    <li class="nav-item"><a href="#fontSizes" class="nav-link" data-coreui-toggle="tab"><?php echo app('translator')->get('settings.fontSizes'); ?></a></li>
    <li class="nav-item"><a href="#fontLineheight" class="nav-link" data-coreui-toggle="tab"><?php echo app('translator')->get('settings.fontLineheight'); ?></a></li>
    <?php if($fonts): ?>
        <li class="nav-item"><a href="#typography" class="nav-link" data-coreui-toggle="tab"><?php echo app('translator')->get('settings.typography'); ?></a></li>
    <?php endif; ?>
</ul>
<div class="tab-content">
    <div id="themeGeneral" class="tab-pane fade show active">
        <?php if($menus): ?>
            <div class="form-group mb-3 row">
                <label for="_main_menu" class="col-md-3 col-form-label"><?php echo app('translator')->get('settings.mainMenu'); ?></label>
                <div class="col-md-9">
                    <select class="form-control" name="settings[_main_menu]" id="_main_menu">
                        <option value=""><?php echo app('translator')->get('common.selectOne'); ?></option>
                        <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($menu->name); ?>" <?php if($menu->name == setting('_main_menu', 'Main Menu')): ?> selected <?php endif; ?>>
                                <?php echo e($menu->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="help-block text-muted small"><?php echo app('translator')->get('settings.mainMenuHelp'); ?></span>
                </div>
            </div>
        <?php endif; ?>
        <div class="form-group mb-3 row">
            <label for="tools_layout" class="col-md-3 form-label"><?php echo app('translator')->get('settings.toolsLayout'); ?></label>
            <div class="col-md-9">
                <select class="form-control <?php $__errorArgs = ['settings.canvas.tools_layout'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                    name="settings[canvas][tools_layout]" id="tools_layout">
                    <option value="grid-view"><?php echo app('translator')->get('common.selectOne'); ?></option>
                    <?php $__currentLoopData = tools_layout_options(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $layout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($layout['value']); ?>" <?php if(isset($themeOptions->tools_layout) && $layout['value'] == $themeOptions->tools_layout): ?> selected <?php endif; ?>>
                            <?php echo e($layout['name']); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <span class="help-block d-block text-muted small"><?php echo app('translator')->get('canvas.toolsLayoutHelp'); ?></span>
                <?php $__errorArgs = ['settings.tools_layout'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <span class="invalid-feedback" role="alert">
                        <strong><?php echo e($message); ?></strong>
                    </span>
                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="enable_dark_mode" class="col-md-3 form-label"><?php echo app('translator')->get('canvas.enableDarkMode'); ?></label>
            <div class="col-md-9">
                <label class="switch switch-pill switch-label switch-primary">
                    <input class="switch-input <?php $__errorArgs = ['canvas.enable_dark_mode'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        id="enable_dark_mode" name="settings[canvas][enable_dark_mode]" value="1"
                        <?php echo e(isset($themeOptions->enable_dark_mode) && $themeOptions->enable_dark_mode == '1' ? 'checked' : ''); ?>

                        type="checkbox">
                    <span class="switch-slider" data-checked="&#x2713;" data-unchecked="&#x2715;"></span>
                </label>
                <span class="help-block d-block text-muted small"><?php echo app('translator')->get('canvas.enableDarkModeHelp'); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="dark_default_theme" class="col-md-3 form-label"><?php echo app('translator')->get('canvas.darkThemeDefault'); ?></label>
            <div class="col-md-9" data-conditional-name="settings[canvas][enable_dark_mode]" data-conditional-value="1">
                <label class="switch switch-pill switch-label switch-primary">
                    <input class="switch-input <?php $__errorArgs = ['canvas.dark_default_theme'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        id="dark_default_theme" name="settings[canvas][dark_default_theme]" value="dark"
                        <?php echo e(isset($themeOptions->dark_default_theme) && $themeOptions->dark_default_theme == 'dark' ? 'checked' : ''); ?>

                        type="checkbox">
                    <span class="switch-slider" data-checked="&#x2713;" data-unchecked="&#x2715;"></span>
                </label>
                <span class="help-block d-block text-muted small"><?php echo app('translator')->get('canvas.darkThemeDefaultHelp'); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="enable_search_in_header" class="col-md-3 form-label"><?php echo app('translator')->get('canvas.enableSearchInHeaderText'); ?></label>
            <div class="col-md-9">
                <label class="switch switch-pill switch-label switch-primary">
                    <input class="switch-input <?php $__errorArgs = ['canvas.enable_search_in_header'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                        id="enable_search_in_header" name="settings[canvas][enable_search_in_header]" value="1"
                        <?php echo e(isset($themeOptions->enable_search_in_header) && $themeOptions->enable_search_in_header == 1 ? 'checked' : ''); ?>

                        type="checkbox">
                    <span class="switch-slider" data-checked="&#x2713;" data-unchecked="&#x2715;"></span>
                </label>
                <span class="help-block d-block text-muted small"><?php echo app('translator')->get('canvas.enableSearchInHeaderTextHelp'); ?></span>
            </div>
        </div>
    </div>
    <div id="lightTheme" class="tab-pane fade show">
        <div class="form-group row mb-3">
            <label for="primary_color" class="col-md-3 form-label"><?php echo app('translator')->get('settings.primaryColor'); ?></label>
            <div class="col-md-9">
                <div class="input-group colorPicker">
                    <input type="text" id="primary_color" class="form-control"
                        name="settings[canvas][light][primary_color]"
                        value="<?php echo e($themeOptions->light->primary_color ?? '#FA8617'); ?>" />
                    <span class="input-group-append"
                        style="background-color:<?php echo e($themeOptions->light->primary_color ?? '#FA8617'); ?>">
                        <?php if (isset($component)) { $__componentOriginal1245a7280dd23eebc265ff9b9451a331 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1245a7280dd23eebc265ff9b9451a331 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.color-picker','data' => ['color' => $themeOptions->light->primary_color ?? '#FA8617']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('color-picker'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($themeOptions->light->primary_color ?? '#FA8617')]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $attributes = $__attributesOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $component = $__componentOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__componentOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
                    </span>
                </div>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.primaryColorHelp'); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '#FA8617']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="secondary_color" class="col-md-3 form-label"><?php echo app('translator')->get('settings.secondaryColor'); ?></label>
            <div class="col-md-9">
                <div class="input-group colorPicker">
                    <input type="text" id="secondary_color" class="form-control"
                        name="settings[canvas][light][secondary_color]"
                        value="<?php echo e($themeOptions->light->secondary_color ?? '#26282D'); ?>" />
                    <span class="input-group-append"
                        style="background-color:<?php echo e($themeOptions->light->secondary_color ?? '#26282D'); ?>">
                        <?php if (isset($component)) { $__componentOriginal1245a7280dd23eebc265ff9b9451a331 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1245a7280dd23eebc265ff9b9451a331 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.color-picker','data' => ['color' => $themeOptions->light->secondary_color ?? '#26282D']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('color-picker'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($themeOptions->light->secondary_color ?? '#26282D')]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $attributes = $__attributesOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $component = $__componentOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__componentOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
                    </span>
                </div>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.primaryColorHelp'); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '#26282D']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="background_color" class="col-md-3 form-label"><?php echo app('translator')->get('settings.backgroundColor'); ?></label>
            <div class="col-md-9">
                <div class="input-group colorPicker">
                    <input type="text" id="background_color" class="form-control"
                        name="settings[canvas][light][background_color]"
                        value="<?php echo e($themeOptions->light->background_color ?? '#F2F3F4'); ?>" />
                    <span class="input-group-append"
                        style="background-color:<?php echo e($themeOptions->light->background_color ?? '#F2F3F4'); ?>">
                        <?php if (isset($component)) { $__componentOriginal1245a7280dd23eebc265ff9b9451a331 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1245a7280dd23eebc265ff9b9451a331 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.color-picker','data' => ['color' => $themeOptions->light->background_color ?? '#F2F3F4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('color-picker'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($themeOptions->light->background_color ?? '#F2F3F4')]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $attributes = $__attributesOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $component = $__componentOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__componentOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
                    </span>
                </div>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.backgroundColorHelp'); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '#F2F3F4']); ?></span>
            </div>
        </div>
        
        <div class="form-group row mb-3">
            <label for="body_color" class="col-md-3 form-label"><?php echo app('translator')->get('settings.bodyTextColor'); ?></label>
            <div class="col-md-9">
                <div class="input-group colorPicker">
                    <input type="text" id="body_color" class="form-control"
                        name="settings[canvas][light][body_color]"
                        value="<?php echo e($themeOptions->light->body_color ?? '#212529'); ?>" />
                    <span class="input-group-append"
                        style="background-color:<?php echo e($themeOptions->light->body_color ?? '#212529'); ?>">
                        <?php if (isset($component)) { $__componentOriginal1245a7280dd23eebc265ff9b9451a331 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1245a7280dd23eebc265ff9b9451a331 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.color-picker','data' => ['color' => $themeOptions->light->body_color ?? '#212529']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('color-picker'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($themeOptions->light->body_color ?? '#212529')]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $attributes = $__attributesOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $component = $__componentOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__componentOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
                    </span>
                </div>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.bodyTextColorHelp'); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '#212529']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="border_color" class="col-md-3 form-label"><?php echo app('translator')->get('settings.borderColor'); ?></label>
            <div class="col-md-9">
                <div class="input-group colorPicker">
                    <input type="text" id="border_color" class="form-control"
                        name="settings[canvas][light][border_color]"
                        value="<?php echo e($themeOptions->light->border_color ?? '#E8E8E8'); ?>" />
                    <span class="input-group-append"
                        style="background-color:<?php echo e($themeOptions->light->border_color ?? '#E8E8E8'); ?>">
                        <?php if (isset($component)) { $__componentOriginal1245a7280dd23eebc265ff9b9451a331 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1245a7280dd23eebc265ff9b9451a331 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.color-picker','data' => ['color' => $themeOptions->light->border_color ?? '#E8E8E8']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('color-picker'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($themeOptions->light->border_color ?? '#E8E8E8')]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $attributes = $__attributesOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $component = $__componentOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__componentOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
                </div>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.borderColorHelp'); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '#E8E8E8']); ?></span>
            </div>
        </div>
    </div>
    <div id="darkTheme" class="tab-pane fade show">
        <div class="form-group row mb-3">
            <label for="dark_primary_color" class="col-md-3 form-label"><?php echo app('translator')->get('canvas.darkPrimaryColor'); ?></label>
            <div class="col-md-9">
                <div class="input-group colorPicker">
                    <input type="text" id="dark_primary_color" class="form-control"
                        name="settings[canvas][dark][primary_color]"
                        value="<?php echo e($themeOptions->dark->primary_color ?? '#1A1927'); ?>" />
                    <span class="input-group-append"
                        style="background-color:<?php echo e($themeOptions->dark->primary_color ?? '#1A1927'); ?>">
                        <?php if (isset($component)) { $__componentOriginal1245a7280dd23eebc265ff9b9451a331 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1245a7280dd23eebc265ff9b9451a331 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.color-picker','data' => ['color' => $themeOptions->dark->primary_color ?? '#1A1927']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('color-picker'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($themeOptions->dark->primary_color ?? '#1A1927')]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $attributes = $__attributesOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $component = $__componentOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__componentOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
                </div>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.primaryColorHelp'); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '#1A1927']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="dark_secondary_color" class="col-md-3 form-label"><?php echo app('translator')->get('canvas.darkSecondaryColor'); ?></label>
            <div class="col-md-9">
                <div class="input-group colorPicker">
                    <input type="text" id="dark_secondary_color" class="form-control"
                        name="settings[canvas][dark][secondary_color]"
                        value="<?php echo e($themeOptions->dark->secondary_color ?? '#232230'); ?>" />
                    <span class="input-group-append"
                        style="background-color:<?php echo e($themeOptions->dark->secondary_color ?? '#232230'); ?>">
                        <?php if (isset($component)) { $__componentOriginal1245a7280dd23eebc265ff9b9451a331 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1245a7280dd23eebc265ff9b9451a331 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.color-picker','data' => ['color' => $themeOptions->dark->secondary_color ?? '#232230']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('color-picker'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($themeOptions->dark->secondary_color ?? '#232230')]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $attributes = $__attributesOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $component = $__componentOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__componentOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
                </div>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.secondaryColorHelp'); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '#232230']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="dark_body_text_color" class="col-md-3 form-label"><?php echo app('translator')->get('settings.bodyTextColorDark'); ?></label>
            <div class="col-md-9">
                <div class="input-group colorPicker">
                    <input type="text" id="dark_body_text_color" class="form-control"
                        name="settings[canvas][dark][body_text_color]"
                        value="<?php echo e($themeOptions->dark->body_text_color ?? '#dbdbdb'); ?>" />
                    <span class="input-group-append"
                        style="background-color:<?php echo e($themeOptions->dark->body_text_color ?? '#dbdbdb'); ?>">
                        <?php if (isset($component)) { $__componentOriginal1245a7280dd23eebc265ff9b9451a331 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1245a7280dd23eebc265ff9b9451a331 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.color-picker','data' => ['color' => $themeOptions->dark->body_text_color ?? '#dbdbdb']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('color-picker'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($themeOptions->dark->body_text_color ?? '#dbdbdb')]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $attributes = $__attributesOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $component = $__componentOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__componentOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
                </div>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.bodyTextColorDarkHelp'); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '#dbdbdb']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="dark_border_color" class="col-md-3 form-label"><?php echo app('translator')->get('settings.borderColor'); ?></label>
            <div class="col-md-9">
                <div class="input-group colorPicker">
                    <input type="text" id="dark_border_color" class="form-control"
                        name="settings[canvas][dark][border_color]"
                        value="<?php echo e($themeOptions->dark->border_color ?? '#272634'); ?>" />
                    <span class="input-group-append"
                        style="background-color:<?php echo e($themeOptions->dark->border_color ?? '#272634'); ?>">
                        <?php if (isset($component)) { $__componentOriginal1245a7280dd23eebc265ff9b9451a331 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1245a7280dd23eebc265ff9b9451a331 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.color-picker','data' => ['color' => $themeOptions->dark->border_color ?? '#272634']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('color-picker'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['color' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($themeOptions->dark->border_color ?? '#272634')]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $attributes = $__attributesOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__attributesOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1245a7280dd23eebc265ff9b9451a331)): ?>
<?php $component = $__componentOriginal1245a7280dd23eebc265ff9b9451a331; ?>
<?php unset($__componentOriginal1245a7280dd23eebc265ff9b9451a331); ?>
<?php endif; ?>
                </div>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.borderColorHelp'); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '#272634']); ?></span>
            </div>
        </div>
    </div>
    <div id="fontSizes" class="tab-pane fade">
        <div class="form-group row mb-3">
            <label for="body_font_size" class="col-md-3 form-label"><?php echo app('translator')->get('settings.tagFontSize', ['tag' => 'Body']); ?></label>
            <div class="col-md-9">
                <input type="text" id="body_font_size" class="form-control"
                    name="settings[canvas][body_font_size]" value="<?php echo e($themeOptions->body_font_size ?? '1rem'); ?>" />
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.tagFontSizeHelp', ['tag' => 'Body']); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '.875rem']); ?></span>
            </div>
        </div>
        <h5 class="mb-4"><?php echo app('translator')->get('settings.headingSize'); ?></h5>
        <div class="form-group row mb-3">
            <label for="h1_font_size" class="col-md-3 form-label"><?php echo app('translator')->get('settings.tagFontSize', ['tag' => 'H1']); ?></label>
            <div class="col-md-9">
                <input type="text" id="h1_font_size" class="form-control" name="settings[elegant][h1_font_size]"
                    value="<?php echo e($themeOptions->h1_font_size ?? '1.5rem'); ?>" />
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.tagFontSizeHelp', ['tag' => 'H1']); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '1.5rem']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="h2_font_size" class="col-md-3 form-label"><?php echo app('translator')->get('settings.tagFontSize', ['tag' => 'H2']); ?></label>
            <div class="col-md-9">
                <input type="text" id="h2_font_size" class="form-control" name="settings[elegant][h2_font_size]"
                    value="<?php echo e($themeOptions->h2_font_size ?? '1.25rem'); ?>" />
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.tagFontSizeHelp', ['tag' => 'H2']); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '1.25rem']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="h3_font_size" class="col-md-3 form-label"><?php echo app('translator')->get('settings.tagFontSize', ['tag' => 'H3']); ?></label>
            <div class="col-md-9">
                <input type="text" id="h3_font_size" class="form-control" name="settings[elegant][h3_font_size]"
                    value="<?php echo e($themeOptions->h3_font_size ?? '1.125rem'); ?>" />
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.tagFontSizeHelp', ['tag' => 'H3']); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '1.125rem']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="h4_font_size" class="col-md-3 form-label"><?php echo app('translator')->get('settings.tagFontSize', ['tag' => 'H4']); ?></label>
            <div class="col-md-9">
                <input type="text" id="h4_font_size" class="form-control" name="settings[elegant][h4_font_size]"
                    value="<?php echo e($themeOptions->h4_font_size ?? '1rem'); ?>" />
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.tagFontSizeHelp', ['tag' => 'H4']); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '1rem']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="h5_font_size" class="col-md-3 form-label"><?php echo app('translator')->get('settings.tagFontSize', ['tag' => 'H5']); ?></label>
            <div class="col-md-9">
                <input type="text" id="h5_font_size" class="form-control" name="settings[elegant][h5_font_size]"
                    value="<?php echo e($themeOptions->h5_font_size ?? '1.09375rem'); ?>" />
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.tagFontSizeHelp', ['tag' => 'H5']); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '1.09375rem']); ?></span>
            </div>
        </div>
        <div class="form-group row mb-3">
            <label for="h6_font_size" class="col-md-3 form-label"><?php echo app('translator')->get('settings.tagFontSize', ['tag' => 'H6']); ?></label>
            <div class="col-md-9">
                <input type="text" id="h6_font_size" class="form-control" name="settings[elegant][h6_font_size]"
                    value="<?php echo e($themeOptions->h6_font_size ?? '0.875rem'); ?>" />
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.tagFontSizeHelp', ['tag' => 'H6']); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '0.875rem']); ?></span>
            </div>
        </div>
    </div>
    <div id="fontLineheight" class="tab-pane fade">
        <div class="form-group row mb-3">
            <label for="body_line_height" class="col-md-3 form-label"><?php echo app('translator')->get('settings.tagLineheight', ['tag' => 'Body']); ?></label>
            <div class="col-md-9">
                <input type="text" id="body_line_height" class="form-control"
                    name="settings[canvas][body_line_height]"
                    value="<?php echo e($themeOptions->body_line_height ?? '1.5'); ?>" />
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.tagLineheightHelp', ['tag' => 'Body']); ?></span>
                <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => '1.5']); ?></span>
            </div>
        </div>
    </div>
    <?php if($fonts): ?>
        <div id="typography" class="tab-pane fade">
            <div class="form-group row mb-3">
                <label for="body_font" class="col-md-3 form-label"><?php echo app('translator')->get('settings.tagFont', ['tag' => 'Body']); ?></label>
                <div class="col-md-9">
                    <select id="body_font" class="form-control selectedFont"
                        name="settings[canvas][body_font][family]">
                        <option value=""><?php echo app('translator')->get('common.selectOne'); ?></option>
                        <?php
                            $variants = [];
                            $selected = '';
                        ?>
                        <?php $__currentLoopData = $fonts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $font): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                if (isset($themeOptions->body_font->family) && $themeOptions->body_font->family == $font['family']) {
                                    $variants = $font['variants'];
                                    $selected = $themeOptions->body_font->family;
                                }
                            ?>
                            <option data-index="<?php echo e($index); ?>" value="<?php echo e($font['family']); ?>"
                                <?php if($selected === $font['family']): ?> selected <?php endif; ?>><?php echo e($font['family']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="help-block text-muted small"><?php echo app('translator')->get('settings.tagFontHelp', ['tag' => 'Body']); ?></span>
                    <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => 'Nunito']); ?></span>
                    <div class="fontVariants">
                        <select id="body_font_variant" class="form-control"
                            name="settings[canvas][body_font][variant][]" size="8" multiple>
                            <?php $__currentLoopData = $variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-index="<?php echo e($index); ?>" value="<?php echo e($variant); ?>"
                                    <?php if(isset($themeOptions->body_font->variant) && in_array($variant, $themeOptions->body_font->variant)): ?> selected <?php endif; ?>><?php echo e($variant); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label for="heading_font" class="col-md-3 form-label"><?php echo app('translator')->get('settings.tagFont', ['tag' => 'Heading']); ?></label>
                <div class="col-md-9">
                    <select id="heading_font" class="form-control selectedFont"
                        name="settings[canvas][heading_font][family]">
                        <?php
                            $variants = [];
                            $selected = '';
                        ?>
                        <option value=""><?php echo app('translator')->get('common.selectOne'); ?></option>
                        <?php $__currentLoopData = $fonts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $font): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                if (isset($themeOptions->heading_font->family) && $themeOptions->heading_font->family == $font['family']) {
                                    $variants = $font['variants'];
                                    $selected = $themeOptions->heading_font->family;
                                }
                            ?>
                            <option data-index="<?php echo e($index); ?>" value="<?php echo e($font['family']); ?>"
                                <?php if($selected == $font['family']): ?> selected <?php endif; ?>><?php echo e($font['family']); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <span class="help-block text-muted small"><?php echo app('translator')->get('settings.tagFontHelp', ['tag' => 'Heading']); ?></span>
                    <span class="help-block text-muted small"><?php echo app('translator')->get('settings.defaultValue', ['value' => 'Nunito']); ?></span>
                    <div class="fontVariants">
                        <select id="heading_font_variant" class="form-control"
                            name="settings[canvas][heading_font][variant][]" size="8" multiple>
                            <?php $__currentLoopData = $variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option data-index="<?php echo e($index); ?>" value="<?php echo e($variant); ?>"
                                    <?php if(isset($themeOptions->heading_font->variant) && in_array($variant, $themeOptions->heading_font->variant)): ?> selected <?php endif; ?>><?php echo e($variant); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php /**PATH /home/newuserdapi/toolsfi.co/resources/themes/admin/themes/canvas.blade.php ENDPATH**/ ?>